/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FutureResponse {
    private static final Log LOG = LogFactory.getLog(FutureResponse.class);
    private final ResponseCallback responseCallback;
    private final ArrayBlockingQueue<Response> responseSlot = new ArrayBlockingQueue(1);

    public FutureResponse(ResponseCallback responseCallback) {
        this.responseCallback = responseCallback;
    }

    public Response getResult() throws IOException {
        try {
            return this.responseSlot.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Operation interupted: " + e, e);
            }
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public Response getResult(int timeout) throws IOException {
        try {
            return this.responseSlot.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public void set(Response result) {
        if (this.responseSlot.offer(result) && this.responseCallback != null) {
            this.responseCallback.onCompletion(this);
        }
    }
}

