/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeQueueTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(CompositeQueueTest.class);
    protected int total = 10;
    private Connection connection;

    public void testVirtualTopicCreation() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList1 = new ConsumerBean();
        ConsumerBean messageList2 = new ConsumerBean();
        messageList1.setVerbose(true);
        messageList2.setVerbose(true);
        Session session = this.connection.createSession(false, 1);
        Destination producerDestination = this.getProducerDestination();
        Destination destination1 = this.getConsumer1Dsetination();
        Destination destination2 = this.getConsumer2Dsetination();
        LOG.info("Sending to: " + producerDestination);
        LOG.info("Consuming from: " + destination1 + " and " + destination2);
        MessageConsumer c1 = session.createConsumer(destination1);
        MessageConsumer c2 = session.createConsumer(destination2);
        c1.setMessageListener(messageList1);
        c2.setMessageListener(messageList2);
        MessageProducer producer = session.createProducer(producerDestination);
        CompositeQueueTest.assertNotNull((Object)producer);
        for (int i = 0; i < this.total; ++i) {
            producer.send(this.createMessage(session, i));
        }
        this.assertMessagesArrived(messageList1, messageList2);
    }

    protected void assertMessagesArrived(ConsumerBean messageList1, ConsumerBean messageList2) {
        messageList1.assertMessagesArrived(this.total);
        messageList2.assertMessagesArrived(this.total);
    }

    protected TextMessage createMessage(Session session, int i) throws JMSException {
        TextMessage textMessage = session.createTextMessage("message: " + i);
        if (i % 2 != 0) {
            textMessage.setStringProperty("odd", "yes");
        }
        textMessage.setIntProperty("i", i);
        return textMessage;
    }

    protected Destination getConsumer1Dsetination() {
        return new ActiveMQQueue("FOO");
    }

    protected Destination getConsumer2Dsetination() {
        return new ActiveMQTopic("BAR");
    }

    protected Destination getProducerDestination() {
        return new ActiveMQQueue("MY.QUEUE");
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/virtual/composite-queue.xml";
    }
}

