/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.util.IdGenerator;

public class ActiveMQMessageAuditTest
extends TestCase {
    public ActiveMQMessageAuditTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIsDuplicateString() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        IdGenerator idGen = new IdGenerator();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String id = idGen.generateId();
            list.add(id);
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
        }
        for (String id : list) {
            ActiveMQMessageAuditTest.assertTrue((boolean)audit.isDuplicate(id));
        }
    }

    public void testIsDuplicateMessageReference() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        ArrayList<ActiveMQMessage> list = new ArrayList<ActiveMQMessage>();
        for (int i = 0; i < count; ++i) {
            ProducerId producerId = new ProducerId();
            producerId.setConnectionId("test");
            producerId.setSessionId(0L);
            producerId.setValue(1L);
            MessageId id = new MessageId();
            id.setProducerId(producerId);
            id.setProducerSequenceId(i);
            ActiveMQMessage msg = new ActiveMQMessage();
            msg.setMessageId(id);
            list.add(msg);
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(msg.getMessageId()));
        }
        for (MessageReference messageReference : list) {
            ActiveMQMessageAuditTest.assertTrue((boolean)audit.isDuplicate(messageReference));
        }
    }

    public void testIsInOrderString() {
        int count = 10000;
        ActiveMQMessageAudit audit = new ActiveMQMessageAudit();
        IdGenerator idGen = new IdGenerator();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String id = idGen.generateId();
            if (i == 0) {
                ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
                ActiveMQMessageAuditTest.assertTrue((boolean)audit.isInOrder(id));
            }
            if (i <= 1 || i % 2 == 0) continue;
            list.add(id);
        }
        for (String id : list) {
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isInOrder(id));
            ActiveMQMessageAuditTest.assertFalse((boolean)audit.isDuplicate(id));
        }
    }
}

