/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.activemq.util.URISupport;

public class URISupportTest
extends TestCase {
    public void testEmptyCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("broker:()/localhost?persistent=false"));
        URISupportTest.assertEquals((int)0, (int)data.getComponents().length);
    }

    public void testCompositePath() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(path)/path"));
        URISupportTest.assertEquals((String)"path", (String)data.getPath());
        data = URISupport.parseComposite((URI)new URI("test:path"));
        URISupportTest.assertNull((Object)data.getPath());
    }

    public void testSimpleComposite() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:part1"));
        URISupportTest.assertEquals((int)1, (int)data.getComponents().length);
    }

    public void testComposite() throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite((URI)new URI("test:(part1://host,part2://(sub1://part,sube2:part))"));
        URISupportTest.assertEquals((int)2, (int)data.getComponents().length);
    }

    public void testParsingURI() throws Exception {
        URI source = new URI("tcp://localhost:61626/foo/bar?cheese=Edam&x=123");
        Map map = URISupport.parseParamters((URI)source);
        URISupportTest.assertEquals((String)("Size: " + map), (int)2, (int)map.size());
        this.assertMapKey(map, "cheese", "Edam");
        this.assertMapKey(map, "x", "123");
        URI result = URISupport.removeQuery((URI)source);
        URISupportTest.assertEquals((String)"result", (Object)new URI("tcp://localhost:61626/foo/bar"), (Object)result);
    }

    protected void assertMapKey(Map map, String key, Object expected) {
        URISupportTest.assertEquals((String)("Map key: " + key), map.get(key), (Object)expected);
    }

    public void testParsingCompositeURI() throws URISyntaxException {
        URISupport.parseComposite((URI)new URI("broker://(tcp://localhost:61616)?name=foo"));
    }

    public void testCheckParenthesis() throws Exception {
        String str = "fred:(((ddd))";
        URISupportTest.assertFalse((boolean)URISupport.checkParenthesis((String)str));
        str = str + ")";
        URISupportTest.assertTrue((boolean)URISupport.checkParenthesis((String)str));
    }
}

