/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.util.IOHelper;

public class HashTest
extends TestCase {
    private static final int COUNT = 10000;
    private HashIndex hashIndex;
    private File directory;
    private IndexManager indexManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.directory = new File(IOHelper.getDefaultDataDirectory());
        this.directory.mkdirs();
        IOHelper.deleteChildren((File)this.directory);
        this.indexManager = new IndexManager(this.directory, "im-hash-test", "rw", null, new AtomicLong());
        this.hashIndex = new HashIndex(this.directory, "testHash", this.indexManager);
        this.hashIndex.setNumberOfBins(12);
        this.hashIndex.setPageSize(32768);
        this.hashIndex.setKeyMarshaller(Store.STRING_MARSHALLER);
    }

    public void testHashIndex() throws Exception {
        this.doTest(300);
        this.hashIndex.clear();
        this.hashIndex.unload();
        this.doTest(600);
        this.hashIndex.clear();
        this.hashIndex.unload();
        this.doTest(128);
    }

    public void doTest(int pageSize) throws Exception {
        String keyRoot = "key:";
        this.hashIndex.setPageSize(pageSize);
        this.hashIndex.load();
        this.doInsert(keyRoot);
        this.hashIndex.unload();
        this.hashIndex.load();
        this.checkRetrieve(keyRoot);
        this.doRemove(keyRoot);
        this.hashIndex.unload();
        this.hashIndex.load();
        this.doInsert(keyRoot);
        this.doRemoveHalf(keyRoot);
        this.doInsertHalf(keyRoot);
        this.hashIndex.unload();
        this.hashIndex.load();
        this.checkRetrieve(keyRoot);
        this.hashIndex.unload();
    }

    void doInsert(String keyRoot) throws Exception {
        for (int i = 0; i < 10000; ++i) {
            IndexItem value = this.indexManager.createNewIndex();
            this.indexManager.storeIndex(value);
            this.hashIndex.store((Object)(keyRoot + i), (StoreEntry)value);
        }
    }

    void checkRetrieve(String keyRoot) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            IndexItem item = (IndexItem)this.hashIndex.get((Object)(keyRoot + i));
            HashTest.assertNotNull((Object)item);
        }
    }

    void doRemoveHalf(String keyRoot) throws Exception {
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 != 0) continue;
            this.hashIndex.remove((Object)(keyRoot + i));
        }
    }

    void doInsertHalf(String keyRoot) throws Exception {
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 != 0) continue;
            IndexItem value = this.indexManager.createNewIndex();
            this.indexManager.storeIndex(value);
            this.hashIndex.store((Object)(keyRoot + i), (StoreEntry)value);
        }
    }

    void doRemove(String keyRoot) throws Exception {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.hashIndex.remove((Object)(keyRoot + i));
        }
        for (i = 0; i < 10000; ++i) {
            IndexItem item = (IndexItem)this.hashIndex.get((Object)(keyRoot + i));
            HashTest.assertNull((Object)item);
        }
    }

    void doRemoveBackwards(String keyRoot) throws Exception {
        int i;
        for (i = 9999; i >= 0; --i) {
            this.hashIndex.remove((Object)(keyRoot + i));
        }
        for (i = 0; i < 10000; ++i) {
            IndexItem item = (IndexItem)this.hashIndex.get((Object)(keyRoot + i));
            HashTest.assertNull((Object)item);
        }
    }

    protected void tearDown() throws Exception {
        File[] files;
        super.tearDown();
        for (File file : files = this.directory.listFiles()) {
            file.delete();
        }
    }
}

