/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.store;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProgressPrinter;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadTester
extends JmsTestSupport {
    private static final Log LOG = LogFactory.getLog(LoadTester.class);
    protected int messageSize = 65536;
    protected int produceCount = 10000;

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/broker/store/loadtester.xml"));
    }

    protected ConnectionFactory createConnectionFactory() throws URISyntaxException, IOException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getServer().getConnectURI());
        factory.setUseAsyncSend(true);
        return factory;
    }

    public void testQueueSendThenAddConsumer() throws Exception {
        ProgressPrinter printer = new ProgressPrinter(this.produceCount, 20L);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.setUseCompression(false);
        this.connection.getPrefetchPolicy().setAll(10);
        this.connection.start();
        Session session = this.connection.createSession(false, 3);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(2);
        LOG.info((Object)("Sending " + this.produceCount + " messages that are " + (double)this.messageSize / 1024.0 + "k large, for a total of " + (double)(this.produceCount * this.messageSize) / 1048576.0 + " megs of data."));
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.produceCount; ++i) {
            printer.increment();
            BytesMessage msg = session.createBytesMessage();
            msg.writeBytes(new byte[this.messageSize]);
            producer.send((Message)msg);
        }
        long end1 = System.currentTimeMillis();
        LOG.info((Object)("Produced messages/sec: " + (double)this.produceCount * 1000.0 / (double)(end1 - start)));
        printer = new ProgressPrinter(this.produceCount, 10L);
        start = System.currentTimeMillis();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        for (int i = 0; i < this.produceCount; ++i) {
            printer.increment();
            LoadTester.assertNotNull((String)("Getting message: " + i), (Object)consumer.receive(20000L));
        }
        end1 = System.currentTimeMillis();
        LOG.info((Object)("Consumed messages/sec: " + (double)this.produceCount * 1000.0 / (double)(end1 - start)));
    }

    public static Test suite() {
        return LoadTester.suite(LoadTester.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LoadTester.suite());
    }
}

