/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;

public class ProducerFlowControlTest
extends JmsTestSupport {
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    ActiveMQQueue queueB = new ActiveMQQueue("QUEUE.B");
    private TransportConnector connector;
    private ActiveMQConnection connection;

    public void test2ndPubisherWithProducerWindowSendConnectionThatIsBlocked() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setProducerWindowSize(65536);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void test2ndPubisherWithSyncSendConnectionThatIsBlocked() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setAlwaysSyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void testSimpleSendReceive() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setAlwaysSyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        CountDownLatch pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void test2ndPubisherWithStandardConnectionThatIsBlocked() throws Exception {
        ConnectionFactory factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertFalse((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
    }

    private void fillQueue(final ActiveMQQueue queue) throws JMSException, InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        new Thread("Fill thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(1);
                    while (keepGoing.get()) {
                        done.set(false);
                        producer.send((Message)session.createTextMessage("Hello World"));
                    }
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        while (true) {
            Thread.sleep(1000L);
            if (done.get()) break;
            done.set(true);
        }
        keepGoing.set(false);
    }

    private CountDownLatch asyncSendTo(final ActiveMQQueue queue, final String message) throws JMSException {
        final CountDownLatch done = new CountDownLatch(1);
        new Thread("Send thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(1);
                    producer.send((Message)session.createTextMessage(message));
                    done.countDown();
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        return done;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(1L);
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new VMPendingSubscriberMessageStoragePolicy());
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        policyMap.setDefaultEntry(policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    protected void tearDown() throws Exception {
        TcpTransport t = (TcpTransport)this.connection.getTransport().narrow(TcpTransport.class);
        t.getTransportListener().onException(new IOException("Disposed."));
        this.connection.getTransport().stop();
        super.tearDown();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

