/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import abbot.tester.WindowTester;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import org.fest.assertions.Assertions;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.ContainerFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WindowFixture<T extends Window>
extends ContainerFixture<T> {
    public WindowFixture(Class<? extends T> type) {
        this(RobotFixture.robotWithCurrentAwtHierarchy(), type);
    }

    public WindowFixture(RobotFixture robot, Class<? extends T> type) {
        super(robot, type);
    }

    public WindowFixture(String name, Class<? extends T> type) {
        this(RobotFixture.robotWithCurrentAwtHierarchy(), name, type);
    }

    public WindowFixture(RobotFixture robot, String name, Class<? extends T> type) {
        super(robot, name, type);
    }

    public WindowFixture(T target) {
        this(RobotFixture.robotWithCurrentAwtHierarchy(), target);
    }

    public WindowFixture(RobotFixture robot, T target) {
        super(robot, target);
    }

    public WindowFixture<T> show() {
        this.robot.showWindow((Window)this.target);
        return this.requireVisible();
    }

    public WindowFixture<T> show(Dimension size) {
        this.robot.showWindow((Window)this.target, size);
        return this.requireVisible();
    }

    public WindowFixture<T> resizeWidthTo(int width) {
        return this.resizeTo(new Dimension(width, ((Window)this.target).getHeight()));
    }

    public WindowFixture<T> resizeHeightTo(int height) {
        return this.resizeTo(new Dimension(((Window)this.target).getWidth(), height));
    }

    public WindowFixture<T> resizeTo(Dimension size) {
        this.windowTester().resize((Container)this.target, size.width, size.height);
        return this;
    }

    public WindowFixture<T> requireSize(Dimension size) {
        Assertions.assertThat((Object)((Window)this.target).getSize()).isEqualTo((Object)size);
        return this;
    }

    protected final WindowTester windowTester() {
        return this.testerCastedTo(WindowTester.class);
    }

    @Override
    public WindowFixture<T> requireVisible() {
        return (WindowFixture)super.requireVisible();
    }

    public final void cleanUp() {
        this.robot.cleanUp();
    }
}

