/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import abbot.Platform;
import abbot.tester.JTableTester;
import javax.swing.JTable;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.ComponentFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableFixture
extends ComponentFixture<JTable> {
    public JTableFixture(RobotFixture robot, String tableName) {
        super(robot, tableName, JTable.class);
    }

    public JTableFixture(RobotFixture robot, JTable target) {
        super(robot, target);
    }

    public final JTableFixture selectCell(int row, int column) {
        this.tableTester().actionSelectCell(this.target, row, column);
        return this;
    }

    public final JTableFixture selectCells(Cell ... cells) {
        int multipleSelectionKey = Platform.isOSX() ? 157 : 17;
        this.tableTester().actionKeyPress(multipleSelectionKey);
        for (Cell c : cells) {
            this.selectCell(c.row, c.column);
        }
        this.tableTester().actionKeyRelease(multipleSelectionKey);
        return this;
    }

    public final String contents() {
        if (((JTable)this.target).getSelectedRowCount() == 0) {
            return null;
        }
        return this.contentsAt(((JTable)this.target).getSelectedRow(), ((JTable)this.target).getSelectedColumn());
    }

    public final String contentsAt(int row, int column) {
        return JTableTester.valueToString((JTable)((JTable)this.target), (int)row, (int)column);
    }

    protected final JTableTester tableTester() {
        return (JTableTester)this.tester();
    }

    public static Cell cell(int row, int column) {
        return new Cell(row, column);
    }

    public static class Cell {
        public final int row;
        public final int column;

        public Cell(int row, int column) {
            this.row = row;
            this.column = column;
        }
    }
}

