/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.ComponentLookupException;
import org.fest.swing.ComponentMatcher;
import org.fest.swing.RobotFixture;
import org.fest.swing.TypeMatcher;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOptionPaneFixture
extends ComponentFixture<JOptionPane> {
    private static final HashMap<Integer, String> messageMap = new HashMap();

    public JOptionPaneFixture(RobotFixture robot) {
        super(robot, (JOptionPane)robot.finder().find(new TypeMatcher(JOptionPane.class, true)));
    }

    public final JOptionPaneFixture click() {
        return (JOptionPaneFixture)super.click();
    }

    public final JOptionPaneFixture focus() {
        return (JOptionPaneFixture)super.focus();
    }

    public final JOptionPaneFixture requireTitle(String title) {
        String actualTitle = ((Dialog)((JOptionPane)this.target).getRootPane().getParent()).getTitle();
        Assertions.assertThat((String)actualTitle).isEqualTo(title);
        return this;
    }

    public final JOptionPaneFixture requireMessage(Object message) {
        Assertions.assertThat((Object)((JOptionPane)this.target).getMessage()).isEqualTo(message);
        return this;
    }

    public final JOptionPaneFixture requireOptions(Object[] options) {
        Assertions.assertThat((Object[])((JOptionPane)this.target).getOptions()).isEqualTo(options);
        return this;
    }

    public final JButtonFixture buttonWithText(final String text) {
        Component component = this.robot.finder().find((Container)this.target, new ComponentMatcher(){

            public boolean matches(Component c) {
                if (!(c instanceof JButton)) {
                    return false;
                }
                return Objects.areEqual((Object)text, (Object)((JButton)c).getText());
            }
        });
        if (component == null) {
            return null;
        }
        return new JButtonFixture(this.robot, (JButton)component);
    }

    public final JButtonFixture button() {
        return new JButtonFixture(this.robot, this.robot.finder().findByType((Container)this.target, JButton.class));
    }

    public final JTextComponentFixture textBox() throws ComponentLookupException {
        JTextComponent textComponent = this.robot.finder().findByType((Container)this.target, JTextComponent.class);
        return new JTextComponentFixture(this.robot, textComponent);
    }

    public final JOptionPaneFixture requireErrorMessage() {
        return this.assertEqualMessageType(0);
    }

    public final JOptionPaneFixture requireInformationMessage() {
        return this.assertEqualMessageType(1);
    }

    public final JOptionPaneFixture requireWarningMessage() {
        return this.assertEqualMessageType(2);
    }

    public final JOptionPaneFixture requireQuestionMessage() {
        return this.assertEqualMessageType(3);
    }

    public final JOptionPaneFixture requirePlainMessage() {
        return this.assertEqualMessageType(-1);
    }

    private JOptionPaneFixture assertEqualMessageType(int expected) {
        Assertions.assertThat((String)this.messageTypeAsText(((JOptionPane)this.target).getMessageType())).isEqualTo(this.messageTypeAsText(expected));
        return this;
    }

    private String messageTypeAsText(int messageType) {
        Integer key = messageType;
        if (!messageMap.containsKey(key)) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"The message type <", key, "> is not valid"}));
        }
        return messageMap.get(key);
    }

    public final JOptionPaneFixture requireVisible() {
        return (JOptionPaneFixture)super.requireVisible();
    }

    public final JOptionPaneFixture requireNotVisible() {
        return (JOptionPaneFixture)super.requireNotVisible();
    }

    public final JOptionPaneFixture requireEnabled() {
        return (JOptionPaneFixture)super.requireEnabled();
    }

    public final JOptionPaneFixture requireDisabled() {
        return (JOptionPaneFixture)super.requireDisabled();
    }

    static {
        messageMap.put(0, "Error Message");
        messageMap.put(1, "Information Message");
        messageMap.put(2, "Warning Message");
        messageMap.put(3, "Question Message");
        messageMap.put(-1, "Plain Message");
    }
}

