/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.fest.swing.ComponentLookupException;
import org.fest.swing.ComponentMatcher;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFileChooserFixture
extends ComponentFixture<JFileChooser> {
    public JFileChooserFixture(RobotFixture robot) {
        super(robot, JFileChooser.class);
    }

    public JFileChooserFixture(RobotFixture robot, String labelName) {
        super(robot, labelName, JFileChooser.class);
    }

    public JFileChooserFixture(RobotFixture robot, JFileChooser target) {
        super(robot, target);
    }

    public final JFileChooserFixture selectFile(final File file) {
        int mode = ((JFileChooser)this.target).getFileSelectionMode();
        boolean isFolder = file.isDirectory();
        if (mode == 0 && isFolder) {
            throw new AssertionError((Object)"The file chooser cannot open directories");
        }
        if (mode == 1 && !isFolder) {
            throw new AssertionError((Object)"The file chooser can only open directories");
        }
        this.robot.invokeAndWait(null, new Runnable(){

            public void run() {
                ((JFileChooser)JFileChooserFixture.this.target).setSelectedFile(file);
            }
        });
        return this;
    }

    public final JFileChooserFixture setCurrentDirectory(final File dir) {
        this.robot.invokeAndWait(null, new Runnable(){

            public void run() {
                ((JFileChooser)JFileChooserFixture.this.target).setCurrentDirectory(dir);
            }
        });
        return this;
    }

    public final JTextComponentFixture fileNameTextBox() {
        return new JTextComponentFixture(this.robot, this.robot.finder().findByType((Container)this.target, JTextField.class));
    }

    public final void cancel() {
        this.cancelButton().requireEnabled().click();
    }

    public final JButtonFixture cancelButton() {
        String buttonText = UIManager.getString("FileChooser.cancelButtonText");
        JButton cancelButton = this.findButton(buttonText);
        if (cancelButton == null) {
            throw this.cannotFindButton("Cancel", buttonText);
        }
        return new JButtonFixture(this.robot, cancelButton);
    }

    public final void approve() {
        this.approveButton().requireEnabled().click();
    }

    public final JButtonFixture approveButton() {
        String buttonText = this.approveButtonText();
        JButton approveButton = this.findButton(buttonText);
        if (approveButton == null) {
            throw this.cannotFindButton("Approve", buttonText);
        }
        return new JButtonFixture(this.robot, approveButton);
    }

    private String approveButtonText() {
        String text = ((JFileChooser)this.target).getApproveButtonText();
        if (Strings.isEmpty((String)text)) {
            text = ((JFileChooser)this.target).getUI().getApproveButtonText((JFileChooser)this.target);
        }
        return text;
    }

    private JButton findButton(final String text) {
        JButton button = (JButton)this.robot.finder().find((Container)this.target, new ComponentMatcher(){

            public boolean matches(Component c) {
                return c instanceof JButton && text.equals(((JButton)c).getText());
            }
        });
        return button;
    }

    private ComponentLookupException cannotFindButton(String name, String text) {
        throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to find ", Strings.quote((String)name), " button with text ", Strings.quote((String)text)}));
    }
}

