/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing;

import abbot.finder.AWTHierarchy;
import abbot.finder.BasicFinder;
import abbot.finder.Hierarchy;
import abbot.finder.Matcher;
import abbot.finder.TestHierarchy;
import java.awt.Component;
import java.awt.Container;
import org.fest.swing.ComponentLookupException;
import org.fest.swing.ComponentMatcher;
import org.fest.swing.NameMatcher;
import org.fest.swing.TypeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFinder {
    private final abbot.finder.ComponentFinder finder;

    public static ComponentFinder robotWithNewAwtHierarchy() {
        return new ComponentFinder((Hierarchy)new TestHierarchy());
    }

    public static ComponentFinder robotWithCurrentAwtHierarchy() {
        return new ComponentFinder((Hierarchy)new AWTHierarchy());
    }

    ComponentFinder(Hierarchy hierarchy) {
        this.finder = new BasicFinder(hierarchy);
    }

    public final <T extends Component> T findByType(Class<T> type) {
        return (T)((Component)type.cast(this.find(new TypeMatcher(type))));
    }

    public final <T extends Component> T findByType(Container root, Class<T> type) {
        return (T)((Component)type.cast(this.find(root, new TypeMatcher(type))));
    }

    public final Component findByName(String name) {
        return this.find(new NameMatcher(name));
    }

    public final <T extends Component> T findByName(String name, Class<T> type) {
        return (T)((Component)type.cast(this.findByName(name)));
    }

    public final Component find(ComponentMatcher m) {
        try {
            return this.finder.find((Matcher)m);
        }
        catch (Exception e) {
            throw new ComponentLookupException(e);
        }
    }

    public final <T extends Component> T findByName(Container root, String name, Class<T> type) {
        return (T)((Component)type.cast(this.findByName(root, name)));
    }

    public Component findByName(Container root, String name) {
        return this.find(root, new NameMatcher(name));
    }

    public Component find(Container root, ComponentMatcher m) {
        try {
            return this.finder.find(root, (Matcher)m);
        }
        catch (Exception e) {
            throw new ComponentLookupException(e);
        }
    }
}

