/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.IO;

public class JarResource
extends URLResource {
    protected transient JarURLConnection _jarConnection;

    JarResource(URL url) {
        super(url, null);
    }

    JarResource(URL url, boolean useCaches) {
        super(url, null, useCaches);
    }

    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return super.getInputStream();
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream is = url.openStream();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(Resource resource, File directory, boolean deleteOnExit) throws IOException {
        boolean subEntryIsDir;
        String urlString;
        int endOfJarUrl;
        int startOfJarUrl;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Extract " + resource + " to " + directory));
        }
        int n = startOfJarUrl = (endOfJarUrl = (urlString = resource.getURL().toExternalForm().trim()).indexOf("!/")) >= 0 ? 4 : 0;
        if (endOfJarUrl < 0) {
            throw new IOException("Not a valid jar url: " + urlString);
        }
        URL jarFileURL = new URL(urlString.substring(startOfJarUrl, endOfJarUrl));
        String subEntryName = endOfJarUrl + 2 < urlString.length() ? urlString.substring(endOfJarUrl + 2) : null;
        boolean bl = subEntryIsDir = subEntryName != null && subEntryName.endsWith("/");
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Extracting entry = " + subEntryName + " from jar " + jarFileURL));
        }
        InputStream is = jarFileURL.openConnection().getInputStream();
        JarInputStream jin = new JarInputStream(is);
        JarEntry entry = null;
        boolean shouldExtract = true;
        while ((entry = jin.getNextJarEntry()) != null) {
            File file;
            block11: {
                block10: {
                    String entryName = entry.getName();
                    shouldExtract = subEntryName != null && entryName.startsWith(subEntryName) ? (subEntryIsDir ? !(entryName = entryName.substring(subEntryName.length())).equals("") : true) : subEntryName == null || entryName.startsWith(subEntryName);
                    if (!shouldExtract) {
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug((String)("Skipping entry: " + entryName));
                        continue;
                    }
                    file = new File(directory, entryName);
                    if (!entry.isDirectory()) break block10;
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    break block11;
                }
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    IO.copy((InputStream)jin, (OutputStream)fout);
                }
                catch (Throwable throwable) {
                    IO.close(fout);
                    throw throwable;
                }
                IO.close((OutputStream)fout);
                if (entry.getTime() >= 0L) {
                    file.setLastModified(entry.getTime());
                }
            }
            if (!deleteOnExit) continue;
            file.deleteOnExit();
        }
    }

    public void extract(File directory, boolean deleteOnExit) throws IOException {
        JarResource.extract(this, directory, deleteOnExit);
    }
}

