/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.kaha.CommandMarshaller;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.MessageIdMarshaller;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.ReferenceStoreAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TopicReferenceStore;
import org.apache.activemq.store.amq.AMQTx;
import org.apache.activemq.store.kahadaptor.AMQTxMarshaller;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.activemq.store.kahadaptor.KahaReferenceStore;
import org.apache.activemq.store.kahadaptor.KahaTopicReferenceStore;
import org.apache.activemq.store.kahadaptor.ReferenceRecord;
import org.apache.activemq.store.kahadaptor.ReferenceRecordMarshaller;
import org.apache.activemq.store.kahadaptor.TopicSubAckMarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaReferenceStoreAdapter
extends KahaPersistenceAdapter
implements ReferenceStoreAdapter {
    private static final Log LOG = LogFactory.getLog(KahaReferenceStoreAdapter.class);
    private static final String STORE_STATE = "store-state";
    private static final String INDEX_VERSION_NAME = "INDEX_VERSION";
    private static final Integer INDEX_VERSION = new Integer(6);
    private static final String RECORD_REFERENCES = "record-references";
    private static final String TRANSACTIONS = "transactions-state";
    private MapContainer stateMap;
    private MapContainer<TransactionId, AMQTx> preparedTransactions;
    private Map<Integer, AtomicInteger> recordReferences = new HashMap<Integer, AtomicInteger>();
    private ListContainer<SubscriptionInfo> durableSubscribers;
    private boolean storeValid;
    private Store stateStore;
    private boolean persistentIndex = true;
    private int indexBinSize = HashIndex.DEFAULT_BIN_SIZE;
    private int indexKeySize = HashIndex.DEFAULT_KEY_SIZE;
    private int indexPageSize = HashIndex.DEFAULT_PAGE_SIZE;

    public KahaReferenceStoreAdapter(AtomicLong size) {
        super(size);
    }

    @Override
    public synchronized MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        throw new RuntimeException("Use createQueueReferenceStore instead");
    }

    @Override
    public synchronized TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        throw new RuntimeException("Use createTopicReferenceStore instead");
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        Store store = this.getStateStore();
        boolean empty = store.getMapContainerIds().isEmpty();
        this.stateMap = store.getMapContainer("state", STORE_STATE);
        this.stateMap.load();
        this.storeValid = true;
        if (!empty) {
            Integer indexVersion;
            AtomicBoolean status = (AtomicBoolean)this.stateMap.get(STORE_STATE);
            if (status != null) {
                this.storeValid = status.get();
            }
            if (this.storeValid && ((indexVersion = (Integer)this.stateMap.get(INDEX_VERSION_NAME)) == null || indexVersion < INDEX_VERSION)) {
                this.storeValid = false;
                LOG.warn((Object)"Indexes at an older version - need to regenerate");
            }
            if (this.storeValid && this.stateMap.containsKey(RECORD_REFERENCES)) {
                this.recordReferences = (Map)this.stateMap.get(RECORD_REFERENCES);
            }
        }
        this.stateMap.put(STORE_STATE, new AtomicBoolean());
        this.stateMap.put(INDEX_VERSION_NAME, INDEX_VERSION);
        this.durableSubscribers = store.getListContainer("durableSubscribers");
        this.durableSubscribers.setMarshaller(new CommandMarshaller());
        this.preparedTransactions = store.getMapContainer("transactions", TRANSACTIONS, false);
        this.preparedTransactions.setKeyMarshaller(Store.COMMAND_MARSHALLER);
        this.preparedTransactions.setValueMarshaller(new AMQTxMarshaller(this.wireFormat));
    }

    @Override
    public synchronized void stop() throws Exception {
        this.stateMap.put(RECORD_REFERENCES, this.recordReferences);
        this.stateMap.put(STORE_STATE, new AtomicBoolean(true));
        this.stateMap.put(INDEX_VERSION_NAME, INDEX_VERSION);
        if (this.stateStore != null) {
            this.stateStore.close();
            this.stateStore = null;
            this.stateMap = null;
        }
        super.stop();
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
    }

    @Override
    public boolean isStoreValid() {
        return this.storeValid;
    }

    @Override
    public ReferenceStore createQueueReferenceStore(ActiveMQQueue destination) throws IOException {
        ReferenceStore rc = (ReferenceStore)this.queues.get(destination);
        if (rc == null) {
            rc = new KahaReferenceStore(this, this.getMapReferenceContainer(destination, "queue-data"), destination);
            this.messageStores.put(destination, rc);
            this.queues.put(destination, rc);
        }
        return rc;
    }

    @Override
    public TopicReferenceStore createTopicReferenceStore(ActiveMQTopic destination) throws IOException {
        TopicReferenceStore rc = (TopicReferenceStore)this.topics.get(destination);
        if (rc == null) {
            Store store = this.getStore();
            MapContainer<MessageId, ReferenceRecord> messageContainer = this.getMapReferenceContainer(destination.getPhysicalName(), "topic-data");
            MapContainer subsContainer = this.getSubsMapContainer(destination.getPhysicalName() + "-Subscriptions", "blob");
            ListContainer ackContainer = store.getListContainer(destination.getPhysicalName(), "topic-acks");
            ackContainer.setMarshaller(new TopicSubAckMarshaller());
            rc = new KahaTopicReferenceStore(store, this, messageContainer, ackContainer, subsContainer, destination);
            this.messageStores.put(destination, rc);
            this.topics.put(destination, rc);
        }
        return rc;
    }

    protected MapContainer<MessageId, ReferenceRecord> getMapReferenceContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        MapContainer container = store.getMapContainer(id, containerName, this.persistentIndex);
        container.setIndexBinSize(this.getIndexBinSize());
        container.setIndexKeySize(this.getIndexKeySize());
        container.setIndexPageSize(this.getIndexPageSize());
        container.setKeyMarshaller(new MessageIdMarshaller());
        container.setValueMarshaller(new ReferenceRecordMarshaller());
        container.load();
        return container;
    }

    synchronized void addInterestInRecordFile(int recordNumber) {
        Integer key = recordNumber;
        AtomicInteger rr = this.recordReferences.get(key);
        if (rr == null) {
            rr = new AtomicInteger();
            this.recordReferences.put(key, rr);
        }
        rr.incrementAndGet();
    }

    synchronized void removeInterestInRecordFile(int recordNumber) {
        Integer key = recordNumber;
        AtomicInteger rr = this.recordReferences.get(key);
        if (rr != null && rr.decrementAndGet() <= 0) {
            this.recordReferences.remove(key);
        }
    }

    @Override
    public Set<Integer> getReferenceFileIdsInUse() throws IOException {
        return this.recordReferences.keySet();
    }

    @Override
    public void clearMessages() throws IOException {
        super.deleteAllMessages();
    }

    @Override
    public void recoverState() throws IOException {
        HashSet<SubscriptionInfo> set = new HashSet<SubscriptionInfo>(this.durableSubscribers);
        for (SubscriptionInfo info : set) {
            LOG.info((Object)("Recovering subscriber state for durable subscriber: " + info));
            TopicReferenceStore ts = this.createTopicReferenceStore((ActiveMQTopic)info.getDestination());
            ts.addSubsciption(info, false);
        }
    }

    @Override
    public Map<TransactionId, AMQTx> retrievePreparedState() throws IOException {
        HashMap<TransactionId, AMQTx> result = new HashMap<TransactionId, AMQTx>();
        this.preparedTransactions.load();
        for (TransactionId key : this.preparedTransactions.keySet()) {
            AMQTx value = this.preparedTransactions.get(key);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void savePreparedState(Map<TransactionId, AMQTx> map) throws IOException {
        this.preparedTransactions.clear();
        for (Map.Entry<TransactionId, AMQTx> entry : map.entrySet()) {
            this.preparedTransactions.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void setDirectory(File directory) {
        File file = new File(directory, "data");
        super.setDirectory(file);
        this.stateStore = this.createStateStore(directory);
    }

    protected synchronized Store getStateStore() throws IOException {
        if (this.stateStore == null) {
            File stateDirectory = new File(this.getDirectory(), "kr-state");
            stateDirectory.mkdirs();
            this.stateStore = this.createStateStore(this.getDirectory());
        }
        return this.stateStore;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        super.deleteAllMessages();
        if (this.stateStore != null) {
            if (this.stateStore.isInitialized()) {
                this.stateStore.clear();
            } else {
                this.stateStore.delete();
            }
        } else {
            File stateDirectory = new File(this.getDirectory(), "kr-state");
            StoreFactory.delete(stateDirectory);
        }
    }

    @Override
    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    @Override
    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    private Store createStateStore(File directory) {
        File stateDirectory = new File(directory, "state");
        stateDirectory.mkdirs();
        try {
            return StoreFactory.open(stateDirectory, "rw");
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to create the state store", (Throwable)e);
            return null;
        }
    }

    protected void addSubscriberState(SubscriptionInfo info) throws IOException {
        this.durableSubscribers.add(info);
    }

    protected void removeSubscriberState(SubscriptionInfo info) {
        this.durableSubscribers.remove(info);
    }

    public int getIndexBinSize() {
        return this.indexBinSize;
    }

    public void setIndexBinSize(int indexBinSize) {
        this.indexBinSize = indexBinSize;
    }

    public int getIndexKeySize() {
        return this.indexKeySize;
    }

    public void setIndexKeySize(int indexKeySize) {
        this.indexKeySize = indexKeySize;
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public void setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
    }
}

