/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.mortbay.log.Log;
import org.mortbay.resource.BadResource;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.JarFileResource;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.IO;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public abstract class Resource
implements Serializable {
    public static boolean __defaultUseCaches = true;
    Object _associate;

    public static void setDefaultUseCaches(boolean useCaches) {
        __defaultUseCaches = useCaches;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URL url) throws IOException {
        return Resource.newResource(url, __defaultUseCaches);
    }

    public static Resource newResource(URL url, boolean useCaches) {
        if (url == null) {
            return null;
        }
        String url_string = url.toExternalForm();
        if (url_string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url);
                return fileResource;
            }
            catch (Exception e) {
                Log.debug("EXCEPTION ", e);
                return new BadResource(url, e.toString());
            }
        }
        if (url_string.startsWith("jar:file:")) {
            return new JarFileResource(url, useCaches);
        }
        if (url_string.startsWith("jar:")) {
            return new JarResource(url, useCaches);
        }
        return new URLResource(url, null, useCaches);
    }

    public static Resource newResource(String resource) throws MalformedURLException, IOException {
        return Resource.newResource(resource, __defaultUseCaches);
    }

    public static Resource newResource(String resource, boolean useCaches) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    if (resource.startsWith("./")) {
                        resource = resource.substring(2);
                    }
                    File file = new File(resource).getCanonicalFile();
                    url = file.toURI().toURL();
                    URLConnection connection = url.openConnection();
                    connection.setUseCaches(useCaches);
                    FileResource fileResource = new FileResource(url, connection, file);
                    return fileResource;
                }
                catch (Exception e2) {
                    Log.debug("EXCEPTION ", e2);
                    throw e;
                }
            }
            Log.warn("Bad Resource: " + resource);
            throw e;
        }
        String nurl = url.toString();
        if (!(nurl.length() <= 0 || nurl.charAt(nurl.length() - 1) == resource.charAt(resource.length() - 1) || nurl.charAt(nurl.length() - 1) == '/' && nurl.charAt(nurl.length() - 2) == resource.charAt(resource.length() - 1) || resource.charAt(resource.length() - 1) == '/' && resource.charAt(resource.length() - 2) == nurl.charAt(nurl.length() - 1))) {
            return new BadResource(url, "Trailing special characters stripped by URL in " + resource);
        }
        return Resource.newResource(url);
    }

    public static Resource newSystemResource(String resource) throws IOException {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (url = loader.getResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null && (loader = Resource.class.getClassLoader()) != null && (url = loader.getResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null && (url = ClassLoader.getSystemResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null) {
            return null;
        }
        return Resource.newResource(url);
    }

    public static Resource newClassPathResource(String resource) {
        return Resource.newClassPathResource(resource, true, false);
    }

    public static Resource newClassPathResource(String name, boolean useCaches, boolean checkParents) {
        URL url = Resource.class.getResource(name);
        if (url == null) {
            try {
                url = Loader.getResource(Resource.class, name, checkParents);
            }
            catch (ClassNotFoundException e) {
                url = ClassLoader.getSystemResource(name);
            }
        }
        if (url == null) {
            return null;
        }
        return Resource.newResource(url, useCaches);
    }

    protected void finalize() {
        this.release();
    }

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract URL getURL();

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    public String encode(String uri) {
        return URIUtil.encodePath(uri);
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object o) {
        this._associate = o;
    }

    public URL getAlias() {
        return null;
    }

    public String getListHTML(String base, boolean parent) throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        Object[] ls = this.list();
        if (ls == null) {
            return null;
        }
        Arrays.sort(ls);
        String title = "Directory: " + base;
        StringBuffer buf = new StringBuffer(4096);
        buf.append("<HTML><HEAD><TITLE>");
        buf.append(title);
        buf.append("</TITLE></HEAD><BODY>\n<H1>");
        buf.append(title);
        buf.append("</H1><TABLE BORDER=0>");
        if (parent) {
            buf.append("<TR><TD><A HREF=");
            buf.append(URIUtil.encodePath(URIUtil.addPaths(base, "../")));
            buf.append(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < ls.length; ++i) {
            String encoded = URIUtil.encodePath((String)ls[i]);
            Resource item = this.addPath(encoded);
            buf.append("<TR><TD><A HREF=\"");
            String path = URIUtil.addPaths(base, encoded);
            if (item.isDirectory() && !path.endsWith("/")) {
                path = URIUtil.addPaths(path, "/");
            }
            buf.append(path);
            buf.append("\">");
            buf.append(StringUtil.replace(StringUtil.replace((String)ls[i], "<", "&lt;"), ">", "&gt;"));
            buf.append("&nbsp;");
            buf.append("</TD><TD ALIGN=right>");
            buf.append(item.length());
            buf.append(" bytes&nbsp;</TD><TD>");
            buf.append(dfmt.format(new Date(item.lastModified())));
            buf.append("</TD></TR>\n");
        }
        buf.append("</TABLE>\n");
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, long start, long count) throws IOException {
        InputStream in = this.getInputStream();
        try {
            in.skip(start);
            if (count < 0L) {
                IO.copy(in, out);
            } else {
                IO.copy(in, out, (long)((int)count));
            }
        }
        finally {
            in.close();
        }
    }
}

