/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Loader;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public class TagLibConfiguration
implements Configuration {
    WebAppContext _context;
    String[] _serverTagLibClasses = new String[]{"org.apache.jasper.servlet.JspServlet", "com.sun.faces.config.ConfigureListener", "org.apache.myfaces.webapp.MyFacesServlet"};

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    protected List getJarResourceList() throws MalformedURLException, IOException {
        Resource lib;
        ArrayList<Resource> list = new ArrayList<Resource>();
        Resource web_inf = this._context.getWebInf();
        if (web_inf != null && web_inf.exists() && (lib = web_inf.addPath("lib/")).exists() && lib.isDirectory()) {
            String[] contents = lib.list();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".jar")) continue;
                list.add(lib.addPath(contents[i]));
            }
        }
        list.addAll(this.getServerJarResourceList());
        Log.debug("TLD search {}", list);
        return list;
    }

    protected List getServerJarResourceList() throws MalformedURLException, IOException {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (int i = 0; this._serverTagLibClasses != null && i < this._serverTagLibClasses.length; ++i) {
            URL jar = TypeUtil.jarFor(this._serverTagLibClasses[i]);
            if (jar == null) continue;
            list.add(Resource.newResource(jar));
        }
        return list;
    }

    private void findTLDs(Set tlds, Resource dir2) throws MalformedURLException, IOException {
        String[] meta_contents = dir2.list();
        for (int j = 0; j < meta_contents.length; ++j) {
            Resource r = dir2.addPath(meta_contents[j]);
            if (r.isDirectory()) {
                this.findTLDs(tlds, r);
                continue;
            }
            if (!meta_contents[j].toLowerCase().endsWith(".tld")) continue;
            tlds.add(r);
        }
    }

    public void configureWebApp() throws Exception {
        Resource web_inf;
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
            Iterator iter = this._context.getResourceAliases().values().iterator();
            while (iter.hasNext()) {
                String location = (String)iter.next();
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                Resource l = this._context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if ((web_inf = this._context.getWebInf()) != null) {
            String[] contents = web_inf.list();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                Resource l = this._context.getWebInf().addPath(contents[i]);
                tlds.add(l);
            }
        }
        List jars = this.getJarResourceList();
        for (int i = 0; i < jars.size(); ++i) {
            Resource jar = (Resource)jars.get(i);
            Resource meta = Resource.newResource("jar:" + jar.getURL() + "!/META-INF/", false);
            if (!meta.exists()) continue;
            this.findTLDs(tlds, meta);
        }
        XmlParser parser = new XmlParser(false);
        parser.redirectEntity("web-jsptaglib_1_1.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", false));
        parser.redirectEntity("web-jsptaglib_1_2.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", false));
        parser.redirectEntity("web-jsptaglib_2_0.xsd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", false));
        parser.redirectEntity("web-jsptaglibrary_1_1.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", false));
        parser.redirectEntity("web-jsptaglibrary_1_2.dtd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", false));
        parser.redirectEntity("web-jsptaglibrary_2_0.xsd", Loader.getResource(TagLibConfiguration.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", false));
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                XmlParser.Node root;
                Resource tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug("TLD=" + tld);
                }
                if ((root = parser.parse(tld.getURL().toString())) == null) {
                    Log.warn("No TLD root in {}", tld);
                    continue;
                }
                for (int i = 0; i < root.size(); ++i) {
                    XmlParser.Node node;
                    Object o = root.get(i);
                    if (!(o instanceof XmlParser.Node) || !"listener".equals((node = (XmlParser.Node)o).getTag())) continue;
                    String className = node.getString("listener-class", false, true);
                    if (Log.isDebugEnabled()) {
                        Log.debug("listener=" + className);
                    }
                    try {
                        Class listenerClass = this.getWebAppContext().loadClass(className);
                        EventListener l = (EventListener)listenerClass.newInstance();
                        this._context.addEventListener(l);
                        continue;
                    }
                    catch (Exception e) {
                        Log.warn("Could not instantiate listener " + className, e);
                    }
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    public void deconfigureWebApp() throws Exception {
    }

    public String[] getServerTagLibClasses() {
        return this._serverTagLibClasses;
    }

    public void setServerTagLibClasses(String[] serverTagLibClasses) {
        this._serverTagLibClasses = serverTagLibClasses;
    }
}

