/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientColorPalette
implements Cloneable {
    private TreeMap keyColorMap;
    private boolean linearMapping;
    private LinkedList listeners;

    public GradientColorPalette() {
        this.keyColorMap = new TreeMap();
        this.linearMapping = true;
        this.listeners = new LinkedList();
        this.addKeyColor(-1.0, new Color(255, 0, 0));
        this.addKeyColor(0.0, new Color(0, 0, 0));
        this.addKeyColor(1.0, new Color(0, 255, 0));
    }

    public GradientColorPalette(double min, double max) {
        this.keyColorMap = new TreeMap();
        this.linearMapping = true;
        this.listeners = new LinkedList();
        this.addKeyColor(min, new Color(255, 0, 0));
        this.addKeyColor(0.0, new Color(0, 0, 0));
        this.addKeyColor(max, new Color(0, 255, 0));
    }

    public GradientColorPalette(Map keyColorMap) {
        this.keyColorMap = new TreeMap(keyColorMap);
        this.linearMapping = true;
        this.listeners = new LinkedList();
    }

    public Color setKeyColor(double value, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color old = (Color)this.keyColorMap.remove(new Double(value));
        this.keyColorMap.put(new Double(value), color);
        this.notifyChangeListeners(new ChangeEvent(this));
        return old;
    }

    public void addKeyColor(double value, int r, int g, int b) throws IllegalArgumentException {
        this.addKeyColor(value, new Color(r, g, b));
    }

    public void addKeyColor(double value, Color color) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException();
        }
        this.keyColorMap.put(new Double(value), color);
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyChangeListeners(ChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChangeListener listener = (ChangeListener)iterator.next();
            listener.stateChanged(event);
        }
    }

    public Set getKeyColors() {
        return this.keyColorMap.keySet();
    }

    public Color getKeyColor(double value) {
        return (Color)this.keyColorMap.get(new Double(value));
    }

    public Color removeKeyColor(double value) {
        Color old = (Color)this.keyColorMap.remove(new Double(value));
        this.notifyChangeListeners(new ChangeEvent(this));
        return old;
    }

    public Color getColor(double value) {
        double proportion;
        Double value2;
        Double value1;
        Double valueObject = new Double(value);
        Color color = (Color)this.keyColorMap.get(valueObject);
        if (color != null) {
            return color;
        }
        try {
            value1 = this.keyColorMap.headMap(valueObject).lastKey();
        }
        catch (NoSuchElementException e) {
            return (Color)this.keyColorMap.get(this.keyColorMap.tailMap(valueObject).firstKey());
        }
        try {
            value2 = this.keyColorMap.tailMap(valueObject).firstKey();
        }
        catch (NoSuchElementException e) {
            return (Color)this.keyColorMap.get(this.keyColorMap.headMap(valueObject).lastKey());
        }
        Color color1 = (Color)this.keyColorMap.get(value1);
        Color color2 = (Color)this.keyColorMap.get(value2);
        if (this.linearMapping) {
            proportion = (value - value1) / (value2 - value1);
        } else if (value < 0.0) {
            if (value2 > 0.0) {
                return new Color(0, 0, 0);
            }
            if (value2 == 0.0) {
                value2 = new Double(value / 100.0);
            }
            double logvalue = Math.log(-value);
            double logvalue1 = Math.log(-value1.doubleValue());
            double logvalue2 = Math.log(-value2.doubleValue());
            proportion = (logvalue - logvalue1) / (logvalue2 - logvalue1);
        } else {
            if (value1 < 0.0) {
                return new Color(0, 0, 0);
            }
            if (value1 == 0.0) {
                value1 = new Double(value / 100.0);
            }
            double logvalue = Math.log(value);
            double logvalue1 = Math.log(value1);
            double logvalue2 = Math.log(value2);
            proportion = (logvalue - logvalue1) / (logvalue2 - logvalue1);
        }
        return new Color((int)((double)color2.getRed() * proportion + (double)color1.getRed() * (1.0 - proportion)), (int)((double)color2.getGreen() * proportion + (double)color1.getGreen() * (1.0 - proportion)), (int)((double)color2.getBlue() * proportion + (double)color1.getBlue() * (1.0 - proportion)));
    }

    public void setLinear(boolean linear) {
        this.linearMapping = linear;
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    public boolean isLinear() {
        return this.linearMapping;
    }

    public Object clone() {
        Iterator iterator = this.listeners.iterator();
        GradientColorPalette clone = new GradientColorPalette(this.keyColorMap);
        clone.setLinear(this.linearMapping);
        while (iterator.hasNext()) {
            ChangeListener listener = (ChangeListener)iterator.next();
            clone.addChangeListener(listener);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        Set thatKeyColors;
        if (!(obj instanceof GradientColorPalette)) {
            return false;
        }
        GradientColorPalette that = (GradientColorPalette)obj;
        if (that.isLinear() != this.linearMapping) {
            return false;
        }
        Set thisKeyColors = this.getKeyColors();
        if (!((Object)thisKeyColors).equals(thatKeyColors = that.getKeyColors())) {
            return false;
        }
        Iterator iterator = thisKeyColors.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            if (this.getKeyColor(value).equals(that.getKeyColor(value))) continue;
            return false;
        }
        return true;
    }
}

