/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

public class UIColorHighlighterAddon
extends AbstractComponentAddon {
    public UIColorHighlighterAddon() {
        super("UIColorHighlighter");
    }

    public void initialize(LookAndFeelAddons addon) {
        ColorUIResource striping = null;
        if (this.isWindows(addon)) {
            striping = this.getWindowStripingColor(addon);
        } else if (this.isMetal(addon)) {
            striping = this.getMetalStripingColor(addon);
        } else if (this.isMac(addon)) {
            striping = this.getMacStripingColor(addon);
        } else if (this.isMotif(addon)) {
            striping = this.getMotifStripingColor(addon);
        }
        ArrayList<Object> defaults = new ArrayList<Object>();
        defaults.addAll(Arrays.asList("UIColorHighlighter.stripingBackground", striping));
        addon.loadDefaults(defaults.toArray());
    }

    protected ColorUIResource getGenericStriping() {
        return new ColorUIResource(229, 229, 229);
    }

    protected ColorUIResource getMacStripingColor(LookAndFeelAddons addon) {
        return new ColorUIResource(237, 243, 254);
    }

    protected ColorUIResource getMetalStripingColor(LookAndFeelAddons addon) {
        ColorUIResource striping = null;
        try {
            Method method = MetalLookAndFeel.class.getMethod("getCurrentTheme", new Class[0]);
            Object currentTheme = method.invoke(null, new Object[0]);
            if (Class.forName("javax.swing.plaf.metal.OceanTheme").isInstance(currentTheme)) {
                striping = new ColorUIResource(230, 238, 246);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (striping == null) {
            striping = new ColorUIResource(235, 235, 255);
        }
        return striping;
    }

    protected ColorUIResource getWindowStripingColor(LookAndFeelAddons addon) {
        if (addon instanceof WindowsClassicLookAndFeelAddons) {
            return new ColorUIResource(218, 222, 233);
        }
        ColorUIResource striping = null;
        String xpStyle = OS.getWindowsVisualStyle();
        striping = "HomeStead".equalsIgnoreCase(xpStyle) ? new ColorUIResource(228, 231, 219) : ("Metallic".equalsIgnoreCase(xpStyle) ? new ColorUIResource(235, 235, 236) : new ColorUIResource(224, 233, 246));
        return striping;
    }

    protected ColorUIResource getMotifStripingColor(LookAndFeelAddons addon) {
        return this.getGenericStriping();
    }
}

