/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

public class LookaheadStringReader {
    private String string;
    private int index = 0;

    public LookaheadStringReader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("parameter string cannot be null");
        }
        this.string = string;
    }

    public String lookahead() {
        if (this.string.length() > this.index) {
            return new String(new char[]{this.string.charAt(this.index)});
        }
        return null;
    }

    public String readTo(String ... delimeters) {
        StringBuffer sb = new StringBuffer();
        while (this.index < this.string.length() && !this.anyEquals(this.lookahead(), delimeters)) {
            sb.append(this.string.charAt(this.index));
            ++this.index;
        }
        return sb.toString();
    }

    private boolean anyEquals(String s, String[] delimeters) {
        for (String delimeter : delimeters) {
            if (!delimeter.equals(s)) continue;
            return true;
        }
        return false;
    }

    public String read() {
        String s = new String(new char[]{this.string.charAt(this.index)});
        ++this.index;
        return s;
    }

    public int getLocation() {
        return this.index;
    }

    public String around(int c) {
        int to;
        int from = this.index - c;
        if (from < 0) {
            from = 0;
        }
        if ((to = this.index + c) >= this.string.length()) {
            to = this.string.length() - 1;
        }
        return this.string.substring(from, to + 1);
    }
}

