/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.proto.repository;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.proto.repository.Experiment;
import fi.csc.microarray.proto.repository.Query;
import fi.csc.microarray.proto.repository.Repository;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryBase
extends Repository {
    @Override
    public boolean requiresAuthentication() {
        return false;
    }

    @Override
    public boolean authenticate(String username, String password) {
        throw new UnsupportedOperationException("repository does not require authentication");
    }

    @Override
    public Iterable<Experiment> executeQuery(Query query) throws MicroarrayException {
        HashMap<String, Experiment> intersection = new HashMap<String, Experiment>();
        for (Query subQuery : query.subQueries()) {
            for (Experiment experiment : this.executeSubQuery(subQuery)) {
                intersection.put(experiment.getUniqueIdentifier(), experiment);
            }
        }
        return intersection.values();
    }

    public abstract Iterable<Experiment> executeSubQuery(Query var1) throws MicroarrayException;
}

