/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.biobeans.BioBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.description.VVSADLSyntax;

public class ChipsterInputTypes {
    public static final VVSADLSyntax.InputType CDNA = new VVSADLSyntax.InputType(){

        public String getName() {
            return "CDNA";
        }

        public boolean isTypeOf(DataBean dataBean) {
            return new BioBean(dataBean).getColorCount() == 2;
        }
    };
    public static final VVSADLSyntax.InputType AFFY = new VVSADLSyntax.InputType(){

        public String getName() {
            return "AFFY";
        }

        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.isContentTypeCompatitible("application/cel");
        }
    };
    public static final VVSADLSyntax.InputType GENE_EXPRS = new VVSADLSyntax.InputType(){

        public String getName() {
            return "GENE_EXPRS";
        }

        public boolean isTypeOf(DataBean dataBean) {
            try {
                Table chips = dataBean.fetchFeature("/column/chip.*").asTable();
                return chips != null && chips.getColumnNames().length > 0;
            }
            catch (MicroarrayException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final VVSADLSyntax.InputType PHENODATA = new VVSADLSyntax.InputType(){

        public String getName() {
            return "PHENODATA";
        }

        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.fetchFeature("/phenodata").exists();
        }
    };
}

