/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataFolder;
import fi.csc.microarray.databeans.fs.FSDataManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mortbay.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSnapshottingSession {
    private static final String METADATA_FILENAME = "snapshot_metadata.txt";
    private static final String ROOT_FOLDER_ID = "0";
    private int snapshotCounter = 0;
    private FSDataManager manager;
    private HashMap<Integer, DataItem> idMap = new HashMap();
    private HashMap<DataItem, Integer> reversedIdMap = new HashMap();

    public FSSnapshottingSession(FSDataManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveSnapshot(File snapshotDir) throws IOException {
        boolean dirOk;
        if (!snapshotDir.exists() && !(dirOk = snapshotDir.mkdir())) {
            throw new IOException("could not create " + snapshotDir.getName());
        }
        StringBuffer metadata = new StringBuffer("");
        int dataCount = this.saveRecursively((FSDataFolder)this.manager.getRootFolder(), snapshotDir, metadata);
        this.saveLinksRecursively((FSDataFolder)this.manager.getRootFolder(), metadata);
        File metadataFile = this.getMetadataFile(snapshotDir);
        metadataFile.createNewFile();
        PrintWriter metadataOut = null;
        try {
            metadataOut = new PrintWriter(new FileWriter(metadataFile));
            metadataOut.print(metadata.toString());
        }
        finally {
            if (metadataOut != null) {
                metadataOut.close();
            }
        }
        return dataCount;
    }

    private void saveLinksRecursively(FSDataFolder folder, StringBuffer metadata) {
        for (DataItem data : folder.getChildren()) {
            if (data instanceof FSDataFolder) {
                this.saveLinksRecursively((FSDataFolder)data, metadata);
                continue;
            }
            DataBean bean = (DataBean)data;
            for (DataBean.Link type : DataBean.Link.values()) {
                for (DataBean target : bean.getLinkTargets(type)) {
                    String beanId = this.fetchId(bean);
                    String targetId = this.fetchId(target);
                    metadata.append("LINK " + type.name() + " " + beanId + " " + targetId + "\n");
                }
            }
        }
    }

    private File getMetadataFile(File snapshotDir) {
        File metadataFile = new File(snapshotDir.getPath() + File.separator + METADATA_FILENAME);
        return metadataFile;
    }

    private int saveRecursively(FSDataFolder folder, File snapshotDirectory, StringBuffer metadata) throws IOException {
        int dataCount = 0;
        String folderId = this.generateId(folder);
        this.saveDataFolderMetadata(folder, folderId, metadata);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof FSDataFolder) {
                int recDataCount = this.saveRecursively((FSDataFolder)data, snapshotDirectory, metadata);
                dataCount += recDataCount;
                continue;
            }
            FSDataBean bean = (FSDataBean)data;
            this.saveDataBeanMetadata(bean, folderId, metadata);
            IO.copy(bean.getContentFile(), new File(snapshotDirectory.getCanonicalPath() + File.separator + bean.getContentFile().getName()));
            ++dataCount;
        }
        return dataCount;
    }

    private void saveDataFolderMetadata(FSDataFolder folder, String folderId, StringBuffer metadata) {
        metadata.append("DATAFOLDER " + folderId + "\n");
        this.saveDataItemMetadata(folder, folderId, metadata);
    }

    private void saveDataBeanMetadata(FSDataBean bean, String folderId, StringBuffer metadata) {
        String beanId = this.generateId(bean);
        metadata.append("DATABEAN " + beanId + " " + bean.getContentFile().getName() + "\n");
        if (bean.getOperation() != null) {
            metadata.append("OPERATION " + beanId + " " + bean.getOperation().getCategoryName() + "/" + bean.getOperation().getName() + "\n");
            if (bean.getOperation().getCategoryColor() != null) {
                metadata.append("OPERATION_COLOR " + beanId + " " + bean.getOperation().getCategoryColor().getRGB() + "\n");
            }
        }
        if (bean.getNotes() != null) {
            metadata.append("NOTES " + beanId + " " + bean.getNotes().replace('\n', ' ') + "\n");
        }
        this.saveDataItemMetadata(bean, beanId, metadata);
    }

    private void saveDataItemMetadata(DataItem data, String folderId, StringBuffer metadata) {
        metadata.append("NAME " + folderId + " " + data.getName() + "\n");
        if (data.getParent() != null) {
            metadata.append("CHILD " + folderId + " " + this.fetchId(data.getParent()) + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> loadFromSnapshot(File snapshotDirectory, DataFolder parentFolder) throws IOException, MicroarrayException {
        File metadataFile = this.getMetadataFile(snapshotDirectory);
        LinkedList<DataItem> newItems = new LinkedList<DataItem>();
        BufferedReader metadataIn = null;
        try {
            metadataIn = new BufferedReader(new FileReader(metadataFile));
            String line = metadataIn.readLine();
            while (line != null) {
                DataBean bean;
                String id;
                String[] split;
                if (line.startsWith("DATAFOLDER ")) {
                    split = line.split(" ");
                    id = split[1];
                    DataFolder folder = this.manager.createFolder("");
                    newItems.add(folder);
                    this.mapId(id, folder);
                } else if (line.startsWith("DATABEAN ")) {
                    split = line.split(" ");
                    id = split[1];
                    File contentFile = new File(snapshotDirectory.getAbsolutePath() + File.separator + split[2]);
                    FSDataBean bean2 = this.manager.createDataBean("<empty>", new FileInputStream(contentFile));
                    Operation importOperation = new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{bean2});
                    bean2.setOperation(importOperation);
                    bean2.setContentType(this.manager.guessContentType(contentFile));
                    newItems.add(bean2);
                    this.mapId(id, bean2);
                } else if (line.startsWith("NAME ")) {
                    split = line.split(" ");
                    id = split[1];
                    String name = FSSnapshottingSession.afterNthSpace(line, 2);
                    DataItem item = this.fetchItem(id);
                    item.setName(name);
                    if (item instanceof DataBean) {
                        DataBean bean3 = (DataBean)item;
                        bean3.setContentType(this.manager.guessContentType(name));
                    }
                } else if (line.startsWith("OPERATION ")) {
                    split = line.split(" ");
                    id = split[1];
                    bean = (DataBean)this.fetchItem(id);
                    String[] opName = FSSnapshottingSession.afterNthSpace(line, 2).split("/");
                    OperationDefinition od = new OperationDefinition(opName[1], new OperationCategory(opName[0]), "", false);
                    Operation op = new Operation(od, new DataBean[]{bean});
                    bean.setOperation(op);
                } else if (line.startsWith("OPERATION_COLOR ")) {
                    split = line.split(" ");
                    id = split[1];
                    bean = (DataBean)this.fetchItem(id);
                    int color = Integer.parseInt(split[2]);
                    bean.getOperation().getDefinition().getCategory().setColor(new Color(color));
                } else if (line.startsWith("CHILD ")) {
                    split = line.split(" ");
                    String childId = split[1];
                    String parentId = split[2];
                    DataFolder parent = parentId.equals(ROOT_FOLDER_ID) ? this.manager.getRootFolder() : (DataFolder)this.fetchItem(parentId);
                    DataItem child = this.fetchItem(childId);
                    parent.addChild(child);
                } else if (line.startsWith("NOTES ")) {
                    split = line.split(" ");
                    id = split[1];
                    String notes = FSSnapshottingSession.afterNthSpace(line, 2);
                    DataBean item = (DataBean)this.fetchItem(id);
                    item.setNotes(notes);
                } else if (line.startsWith("LINK ")) {
                    split = line.split(" ");
                    DataBean.Link link = DataBean.Link.valueOf(split[1]);
                    String fromId = split[2];
                    String toId = split[3];
                    DataBean from = (DataBean)this.fetchItem(fromId);
                    DataBean to = (DataBean)this.fetchItem(toId);
                    from.addLink(link, to);
                } else {
                    throw new RuntimeException("metadata error in " + metadataFile.getCanonicalPath() + ": line could not be processed \"" + line + "\"");
                }
                line = metadataIn.readLine();
            }
        }
        finally {
            if (metadataIn != null) {
                metadataIn.close();
            }
        }
        return newItems;
    }

    private static String afterNthSpace(String line, int nth) {
        int from = 0;
        for (int i = 0; i < nth; ++i) {
            from = line.indexOf(" ", from + 1);
        }
        return line.substring(from + 1);
    }

    private void mapId(String id, DataItem item) {
        Integer iid = Integer.parseInt(id);
        this.idMap.put(iid, item);
        this.reversedIdMap.put(item, iid);
    }

    private String generateId(DataItem data) {
        Integer id = this.snapshotCounter++;
        this.idMap.put(id, data);
        this.reversedIdMap.put(data, id);
        return id.toString();
    }

    private DataItem fetchItem(String id) {
        Integer iid = Integer.parseInt(id);
        return this.idMap.get(iid);
    }

    private String fetchId(DataItem item) {
        return this.reversedIdMap.get(item).toString();
    }
}

