/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataBeanSelector;
import fi.csc.microarray.databeans.DataManagerBase;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.RequestExecuter;
import fi.csc.microarray.util.InputStreamSource;
import fi.csc.microarray.util.LookaheadStringReader;
import fi.csc.microarray.util.StreamStartCache;
import fi.csc.microarray.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataBeanBase
implements DataBean {
    private static final Logger logger = Logger.getLogger(DataBeanBase.class);
    protected DataManagerBase dataManager;
    protected StreamStartCache streamStartCache = null;

    protected DataBeanBase(DataManagerBase dataManager) {
        this.dataManager = dataManager;
    }

    public abstract InputStream getRawContentByteStream() throws MicroarrayException;

    public String toString() {
        return this.getName();
    }

    @Override
    public String toStringRecursively(int i) {
        return Strings.repeat("  ", i) + this.toString();
    }

    @Override
    public boolean isContentTypeCompatitible(String ... alternatives) {
        for (String alternative : alternatives) {
            if (!alternative.toLowerCase().equals(this.getContentType().getType().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Feature fetchFeature(String request) {
        Feature feature = new RequestExecuter(this.dataManager).execute(new LookaheadStringReader(request), this);
        if (feature == null) {
            throw new UnsupportedOperationException("request " + request + " not possible from " + this.getName());
        }
        return feature;
    }

    @Override
    public InputStream getContentByteStream() throws MicroarrayException, IOException {
        if (this.streamStartCache != null) {
            return this.streamStartCache.getInputStream();
        }
        logger.debug("using non-cached stream");
        return this.getRawContentByteStream();
    }

    @Override
    public void initialiseStreamStartCache() throws MicroarrayException, IOException {
        this.streamStartCache = new StreamStartCache(this.getRawContentByteStream(), new InputStreamSource(){

            public InputStream getInputStream() {
                try {
                    return DataBeanBase.this.getRawContentByteStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public List<DataBean> traverseLinks(DataBean.Link type, DataBean.Traversal traversal) {
        DataBeanSelector greedySelector = new DataBeanSelector(){

            public boolean shouldSelect(DataBean bean) {
                return true;
            }

            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        };
        return this.traverseLinks(type, traversal, greedySelector);
    }

    @Override
    public List<DataBean> traverseLinks(DataBean.Link type, DataBean.Traversal traversal, DataBeanSelector selector) {
        LinkedHashSet<DataBean> newBeans;
        LinkedList<DataBean> selected = new LinkedList<DataBean>();
        LinkedList<DataBean> traversed = new LinkedList<DataBean>();
        traversed.add(this);
        this.conditionallySelect(selector, selected, this);
        do {
            newBeans = new LinkedHashSet<DataBean>();
            for (DataBean bean : traversed) {
                LinkedHashSet<DataBean> linkedBeans = new LinkedHashSet<DataBean>();
                if (traversal.isDirect()) {
                    linkedBeans.addAll(bean.getLinkTargets(type));
                }
                if (traversal.isReversed()) {
                    linkedBeans.addAll(bean.getLinkSources(type));
                }
                for (DataBean linkedBean : linkedBeans) {
                    if (traversed.contains(linkedBean) || !selector.shouldTraverse(linkedBean)) continue;
                    newBeans.add(linkedBean);
                }
            }
            for (DataBean newBean : newBeans) {
                traversed.add(newBean);
                this.conditionallySelect(selector, selected, newBean);
            }
        } while (newBeans.size() > 0);
        return selected;
    }

    private void conditionallySelect(DataBeanSelector selector, LinkedList<DataBean> selected, DataBean bean) {
        if (!selected.contains(bean) && selector.shouldSelect(bean)) {
            selected.add(bean);
        }
    }
}

