/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;

public class ClusteredProfiles
extends Visualisation {
    public JComponent getVisualisation(DataBean data, Dimension size) throws Exception {
        int clusterCount = 0;
        Iterable<String> clusters = data.fetchFeature("/column/cluster").asStrings();
        for (String cluster : clusters) {
            int num = Integer.parseInt(cluster);
            if (num <= clusterCount) continue;
            clusterCount = num;
        }
        ArrayList<JFreeChart> charts = new ArrayList<JFreeChart>(clusterCount);
        DefaultCategoryDataset[] datasets = new DefaultCategoryDataset[clusterCount];
        for (int i = 0; i < clusterCount; ++i) {
            datasets[i] = new DefaultCategoryDataset();
        }
        Table samples = data.fetchFeature("/column/*").asTable();
        while (samples.nextRow()) {
            int cluster = samples.getIntValue("cluster");
            for (String sample : samples.getColumnNames()) {
                if (!sample.startsWith("chip.")) continue;
                String sampleName = data.fetchFeature("/phenodata/linked/sample_to_name/" + sample.substring("chip.".length())).asString();
                datasets[cluster - 1].addValue(samples.getFloatValue(sample), (Comparable)((Object)samples.getStringValue(" ")), (Comparable)((Object)sampleName));
            }
        }
        for (int i = 0; i < clusterCount; ++i) {
            CategoryAxis categoryAxis = new CategoryAxis("");
            categoryAxis.setTickLabelsVisible(false);
            NumberAxis valueAxis = new NumberAxis("");
            LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, false);
            renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
            CategoryPlot plot = new CategoryPlot(datasets[i], categoryAxis, valueAxis, renderer);
            ExpressionProfile.ProfileDrawingSupplier drawingSupplier = new ExpressionProfile.ProfileDrawingSupplier();
            plot.setDrawingSupplier(drawingSupplier);
            plot.setOrientation(PlotOrientation.VERTICAL);
            JFreeChart chart = new JFreeChart("Cluster " + (i + 1), JFreeChart.DEFAULT_TITLE_FONT, plot, false);
            charts.add(chart);
        }
        return this.makePanel(charts, size);
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getVisualiser().canVisualise(bean);
        if (isTabular) {
            Table chips = bean.fetchFeature("/column/chip.*").asTable();
            boolean hasProfiles = chips != null && chips.getColumnNames().length > 1;
            boolean hasClusters = bean.fetchFeature("/column/cluster").exists();
            return hasProfiles && hasClusters;
        }
        return false;
    }
}

