/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import com.jgoodies.looks.HeaderStyle;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.ComboBoxRenderer;
import fi.csc.microarray.client.visualisation.VisualisationListModel;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationToolBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(VisualisationToolBar.class);
    public static final int PANEL_WIDTH = 310;
    public boolean isMaximised = false;
    private VisualisationMethod chosenMethod = null;
    private ClientApplication application = Session.getSession().getApplication();
    private JButton redrawButton = ToolBarComponentFactory.createButton("Redraw", VisualConstants.REDRAW_ICON, true, false);
    private JButton helpButton = ToolBarComponentFactory.createButton("Help", true, true);
    private JButton maximiseButton = ToolBarComponentFactory.createButton("Maximize", true, false);
    private VisualisationListModel methodListModel = new VisualisationListModel();
    private JComboBox methodChoiceBox = ToolBarComponentFactory.createComboBox(this.methodListModel);
    private String helpAddress;

    public VisualisationToolBar() {
        this.setLayout(new GridBagLayout());
        this.setFloatable(false);
        this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.redrawButton.setPreferredSize(new Dimension(ToolBarComponentFactory.TEXT_BUTTON_SIZE));
        this.helpButton.setPreferredSize(new Dimension(ToolBarComponentFactory.TEXT_BUTTON_SIZE));
        this.maximiseButton.setPreferredSize(new Dimension(ToolBarComponentFactory.TEXT_BUTTON_SIZE));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 3;
        JLabel titleLabel = new JLabel("Method: ");
        this.add((Component)titleLabel, c);
        this.methodChoiceBox.setBackground(Color.WHITE);
        this.methodChoiceBox.addActionListener(this);
        this.methodChoiceBox.setPreferredSize(ToolBarComponentFactory.COMBOBOX_SIZE);
        this.methodChoiceBox.setRenderer(new ComboBoxRenderer());
        ++c.gridx;
        this.add((Component)this.methodChoiceBox, c);
        ++c.gridx;
        this.add(new JLabel(" "));
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.helpButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JLabel(), c);
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.redrawButton, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 3;
        this.maximiseButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.maximiseButton, c);
        this.redrawButton.setEnabled(false);
        this.helpButton.setVisible(false);
        this.redrawButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.maximiseButton.addActionListener(this);
        this.refreshVisualisationList(null);
        this.application.addPropertyChangeListener(this);
    }

    public void setHelpAddress(String helpAddress) {
        this.helpAddress = helpAddress;
        this.helpButton.setVisible(helpAddress != null);
    }

    private void refreshVisualisationList(List<DataBean> datas) {
        this.maximiseButton.setEnabled(datas != null && datas.size() > 0);
        this.methodListModel.fillMethodsFor(datas);
        this.methodChoiceBox.setEnabled(datas != null && datas.size() > 0);
        this.redrawButton.setEnabled(this.methodChoiceBox.getSelectedItem() != VisualisationMethod.NONE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.methodChoiceBox) {
            this.setHelpAddress(null);
            VisualisationMethod method = (VisualisationMethod)((Object)this.methodChoiceBox.getSelectedItem());
            if (method == null) {
                method = VisualisationMethod.NONE;
            }
            if (this.application.getVisualisationMethod() != method) {
                this.application.setVisualisationMethod(method);
            }
            this.redrawButton.setEnabled(this.methodChoiceBox.getSelectedItem() != VisualisationMethod.NONE);
        } else if (source == this.maximiseButton) {
            this.isMaximised = !this.isMaximised;
            this.application.setMaximisedVisualisationMode(this.isMaximised);
            this.maximiseButton.setText(this.isMaximised ? "Restore" : "Maximize");
        } else if (source == this.redrawButton) {
            this.application.setVisualisationMethod(this.application.getVisualisationMethod());
        } else if (source == this.helpButton) {
            this.application.viewHelp(this.helpAddress);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent dataEvent) {
        block7: {
            if (dataEvent instanceof VisualisationMethodChangedEvent) {
                try {
                    logger.debug("got property change, new visualisation method is " + (Object)((Object)this.application.getVisualisationMethod()));
                    VisualisationMethod newChosenMethod = this.application.getVisualisationMethod();
                    if (this.chosenMethod == newChosenMethod) break block7;
                    logger.debug("method was changed");
                    this.chosenMethod = newChosenMethod;
                    if (this.chosenMethod != null) {
                        logger.debug("updating GUI to method " + (Object)((Object)this.chosenMethod));
                        this.methodChoiceBox.setSelectedItem((Object)this.chosenMethod);
                        this.methodChoiceBox.repaint();
                    }
                }
                catch (Exception e) {
                    this.application.reportException(e);
                }
            } else if (dataEvent instanceof DatasetChoiceEvent) {
                if (this.application.getSelectionManager().getSelectedItem() == null) {
                    this.application.setVisualisationMethod(VisualisationMethod.NONE);
                }
                this.refreshVisualisationList(this.application.getSelectionManager().getSelectedDataBeans());
            }
        }
    }
}

