/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationListModel
implements MutableComboBoxModel {
    private static final Logger logger = Logger.getLogger(VisualisationListModel.class);
    private List<ListDataListener> listeners = new LinkedList<ListDataListener>();
    private List<Object> emptyList = new LinkedList<Object>();
    private List<Object> currentList = new LinkedList<Object>();
    private Object selected = null;
    private DataBean data;
    private ClientApplication application = Session.getSession().getApplication();

    public void addElement(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeElement(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void insertElementAt(Object obj, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = anItem;
    }

    @Override
    public Object getSelectedItem() {
        if (this.data != null) {
            if (this.selected != null) {
                return this.selected;
            }
            if (this.currentList.size() > 0) {
                return this.currentList.get(0);
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.currentList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.currentList.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void fillVariablesFor(DataBean data, VisualisationMethod method) {
        this.data = data;
        try {
            if (data != null) {
                this.currentList = new LinkedList<Object>();
                for (Visualisation.Variable var : method.getVisualiser().getVariablesFor(data)) {
                    this.currentList.add(var);
                }
            } else {
                this.currentList = this.emptyList;
            }
            this.notifyListeners();
        }
        catch (MicroarrayException e) {
            this.currentList = this.emptyList;
            this.application.reportException(e);
        }
    }

    public List<Object> getValues() {
        return this.currentList;
    }

    public void fillMethodsFor(List<DataBean> datas) {
        LinkedList<VisualisationMethod> applicableVisualisations = new LinkedList<VisualisationMethod>();
        for (VisualisationMethod visualisation : VisualisationMethod.values()) {
            applicableVisualisations.add(visualisation);
        }
        if (datas != null) {
            Iterator<DataBean> i$ = datas.iterator();
            while (i$.hasNext()) {
                DataBean data;
                this.data = data = i$.next();
                try {
                    logger.debug("iterating over VisualisationMethods for " + data.getName());
                    for (VisualisationMethod method : VisualisationMethod.values()) {
                        if (method.isApplicableTo(data)) continue;
                        applicableVisualisations.remove((Object)method);
                    }
                }
                catch (Exception e) {
                    this.currentList = this.emptyList;
                    break;
                }
            }
            if (datas.size() > 1) {
                LinkedList<VisualisationMethod> applicableForMultiple = new LinkedList<VisualisationMethod>();
                for (VisualisationMethod multiVisualisation : VisualisationMethod.getApplicableForMultipleDatas()) {
                    if (!applicableVisualisations.contains((Object)multiVisualisation)) continue;
                    applicableForMultiple.add(multiVisualisation);
                }
                this.currentList.clear();
                this.currentList.addAll(applicableForMultiple);
            } else {
                this.currentList.clear();
                this.currentList.addAll(applicableVisualisations);
            }
        } else {
            this.currentList = this.emptyList;
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.getSize());
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(e);
        }
    }

    public DataBean getData() {
        return this.data;
    }
}

