/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.client.screen.Screen;
import java.util.HashMap;
import javax.swing.JFrame;

public class ChildScreenPool {
    private HashMap<String, Screen> childScreens = new HashMap();
    private JFrame mainFrame;

    public ChildScreenPool(JFrame main) {
        this.mainFrame = main;
    }

    public void put(String name, Screen childScreen) {
        this.childScreens.put(name, childScreen);
    }

    public Screen get(String screenName) {
        return this.childScreens.get(screenName);
    }

    public void show(String screenName, boolean packed, Object parameter) {
        this.childScreens.get(screenName).setChildScreenParameter(parameter);
        this.show(screenName, packed);
    }

    public void show(String screenName, boolean packed) {
        JFrame frame = this.childScreens.get(screenName).getFrame();
        if (packed) {
            frame.pack();
        }
        frame.setLocationRelativeTo(this.mainFrame);
        frame.setVisible(true);
    }

    public void disposeAll() {
        for (Screen screen : this.childScreens.values()) {
            if (!screen.hasFrame()) continue;
            screen.getFrame().dispose();
        }
    }

    public boolean hasScreen(String screenName) {
        return this.childScreens.get(screenName) != null;
    }
}

