/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.tools;

import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ColumnTypeManager;
import fi.csc.microarray.client.dataimport.DataColumn;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.trimmer.ConditionalStringReplace;
import fi.csc.microarray.client.dataimport.trimmer.DataTrimmingOperation;
import fi.csc.microarray.client.dataimport.trimmer.NormalStringReplace;
import fi.csc.microarray.client.dataimport.trimmer.NumberToStringReplace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.InternationalFormatter;
import org.jdesktop.swingx.JXTaskPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagValuePanel
extends JXTaskPane
implements ActionListener,
CaretListener,
ChangeListener {
    private JLabel scaleLabel;
    private JComboBox scaleSelector;
    private JLabel[] flagNameLabels;
    private JPanel topFlagBoundariesPanel;
    private JPanel middleFlagBoundariesPanel;
    private JPanel bottomFlagBoundariesPanel;
    private JTextField topFlagValuesField;
    private JTextField middleFlagValuesField;
    private JTextField bottomFlagValuesField;
    private JComboBox topFlagOrderSelector;
    private JLabel bottomFlagOrderLabel;
    private JSpinner topFlagBoundarySpinner;
    private JFormattedTextField topFlagBoundaryField;
    private JLabel middleFlagLowerBoundaryLabel;
    private JLabel middleBoundaryLabel;
    private JLabel middleFlagUpperBoundaryLabel;
    private JSpinner bottomFlagBoundarySpinner;
    private JFormattedTextField bottomFlagBoundaryField;
    private String scale;
    private boolean showingDiscreteScaleExample;
    private double lowerBoundary;
    private double upperBoundary;
    private JSpinner lowerBoundarySpinner;
    private JSpinner upperBoundarySpinner;
    private boolean boundariesAreValid;
    private Map<JFormattedTextField, Integer> extraTokensForBoundaryFields;
    private Map<JFormattedTextField, JSpinner> spinnersForBoundaryFields;
    private DecimalFormat decimalFormat;
    private String topFlagDefault;
    private String middleFlagDefault;
    private String bottomFlagDefault;
    private double topFlagDefaultBoundary;
    private double bottomFlagDefaultBoundary;
    private ImportScreen screen;
    public static final Color TOP_FLAG_COLOR = new Color(210, 255, 200);
    public static final Color MIDDLE_FLAG_COLOR = new Color(255, 255, 180);
    public static final Color BOTTOM_FLAG_COLOR = new Color(255, 210, 200);
    public static final String DISABLED_SCALE;
    public static final String CONTINUOUS_SCALE;
    public static final String DISCRETE_SCALE;
    private static final String LOWER_BOUNDARY_LABEL;
    private static final String UPPER_BOUNDARY_LABEL;
    private static final String MIDDLE_BOUNDARY_LABEL;
    private static final int ORDER_SELECTOR_WIDTH;

    public FlagValuePanel(ImportScreen screen) {
        this("Present P:", "Marginal M", "Absent A", "P", "M", "A", 0.0, 0.0, screen);
    }

    public FlagValuePanel(String topFlagName, String middleFlagName, String bottomFlagName, String topFlagDefault, String middleFlagDefault, String bottomFlagDefault, double topFlagDefaultBoundary, double bottomFlagDefaultBoundary, ImportScreen screen) {
        this.setLayout(new GridBagLayout());
        this.topFlagDefault = topFlagDefault;
        this.middleFlagDefault = middleFlagDefault;
        this.bottomFlagDefault = bottomFlagDefault;
        this.topFlagDefaultBoundary = topFlagDefaultBoundary;
        this.bottomFlagDefaultBoundary = bottomFlagDefaultBoundary;
        this.screen = screen;
        Dimension selectorSize = new Dimension(ORDER_SELECTOR_WIDTH, 20);
        Dimension boundarySpinnerSize = new Dimension(63, 20);
        Dimension valueFieldSize = new Dimension(113, 22);
        this.scaleLabel = new JLabel("Scale:");
        this.scaleSelector = new JComboBox<String>(new String[]{DISABLED_SCALE, CONTINUOUS_SCALE, DISCRETE_SCALE});
        this.scaleSelector.addActionListener(this);
        this.flagNameLabels = new JLabel[3];
        this.flagNameLabels[0] = new JLabel(topFlagName);
        this.flagNameLabels[1] = new JLabel(middleFlagName);
        this.flagNameLabels[2] = new JLabel(bottomFlagName);
        this.topFlagOrderSelector = new JComboBox<String>(new String[]{LOWER_BOUNDARY_LABEL, UPPER_BOUNDARY_LABEL});
        this.topFlagOrderSelector.addActionListener(this);
        this.topFlagOrderSelector.setPreferredSize(selectorSize);
        this.bottomFlagOrderLabel = new JLabel();
        this.extraTokensForBoundaryFields = new HashMap<JFormattedTextField, Integer>();
        this.spinnersForBoundaryFields = new HashMap<JFormattedTextField, JSpinner>();
        this.topFlagBoundarySpinner = new JSpinner(new SpinnerNumberModel(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01));
        this.topFlagBoundarySpinner.addChangeListener(this);
        this.topFlagBoundarySpinner.setPreferredSize(boundarySpinnerSize);
        this.topFlagBoundaryField = ((JSpinner.DefaultEditor)this.topFlagBoundarySpinner.getEditor()).getTextField();
        this.topFlagBoundaryField.addCaretListener(this);
        ((InternationalFormatter)this.topFlagBoundaryField.getFormatter()).setFormat(this.getDecimalFormat());
        this.spinnersForBoundaryFields.put(this.topFlagBoundaryField, this.topFlagBoundarySpinner);
        this.bottomFlagBoundarySpinner = new JSpinner(new SpinnerNumberModel(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01));
        this.bottomFlagBoundarySpinner.addChangeListener(this);
        this.bottomFlagBoundarySpinner.setPreferredSize(boundarySpinnerSize);
        this.bottomFlagBoundaryField = ((JSpinner.DefaultEditor)this.bottomFlagBoundarySpinner.getEditor()).getTextField();
        this.bottomFlagBoundaryField.addCaretListener(this);
        ((InternationalFormatter)this.bottomFlagBoundaryField.getFormatter()).setFormat(this.getDecimalFormat());
        this.spinnersForBoundaryFields.put(this.bottomFlagBoundaryField, this.bottomFlagBoundarySpinner);
        this.topFlagBoundariesPanel = new JPanel(new GridBagLayout());
        this.middleFlagBoundariesPanel = new JPanel(new GridBagLayout());
        this.bottomFlagBoundariesPanel = new JPanel(new GridBagLayout());
        this.topFlagBoundariesPanel.setMinimumSize(valueFieldSize);
        this.middleFlagBoundariesPanel.setMinimumSize(valueFieldSize);
        this.bottomFlagBoundariesPanel.setMinimumSize(valueFieldSize);
        this.middleFlagBoundariesPanel.setOpaque(false);
        this.bottomFlagBoundariesPanel.setOpaque(false);
        this.middleFlagLowerBoundaryLabel = new JLabel();
        this.middleFlagUpperBoundaryLabel = new JLabel();
        this.middleBoundaryLabel = new JLabel(MIDDLE_BOUNDARY_LABEL);
        this.middleBoundaryLabel.setOpaque(false);
        this.topFlagValuesField = new JTextField();
        this.middleFlagValuesField = new JTextField();
        this.bottomFlagValuesField = new JTextField();
        this.setShowingDiscreteScaleExample(true);
        this.bottomFlagValuesField.addCaretListener(this);
        this.middleFlagValuesField.addCaretListener(this);
        this.topFlagValuesField.addCaretListener(this);
        this.showScale(DISABLED_SCALE);
        this.applyDefaultBoundaries();
        this.setFlagModificationEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        this.add((Component)this.scaleLabel, c);
        ++c.gridx;
        this.add((Component)this.scaleSelector, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.flagNameLabels[0], c);
        c.gridy += 2;
        this.add((Component)this.flagNameLabels[1], c);
        c.gridy += 2;
        this.add((Component)this.flagNameLabels[2], c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.insets.bottom = 10;
        this.add((Component)this.topFlagBoundariesPanel, c);
        c.gridy += 2;
        this.add((Component)this.middleFlagBoundariesPanel, c);
        c.gridy += 2;
        this.add((Component)this.bottomFlagBoundariesPanel, c);
        this.updateMiddleFlagBoundaries();
    }

    public void setScale(String scaleId) {
        this.scaleSelector.setSelectedItem(scaleId);
        this.updateFlagTrimmer();
    }

    private void showScale(String scaleId) {
        if (!(scaleId == null || this.scale != null && this.scale.equals(scaleId))) {
            this.scale = scaleId;
            this.topFlagBoundariesPanel.removeAll();
            this.middleFlagBoundariesPanel.removeAll();
            this.bottomFlagBoundariesPanel.removeAll();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            if (scaleId.equals(CONTINUOUS_SCALE)) {
                this.setFlagModificationEnabled(true);
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                this.topFlagBoundariesPanel.add((Component)this.topFlagOrderSelector, c);
                this.bottomFlagBoundariesPanel.add((Component)this.bottomFlagOrderLabel, c);
                ++c.gridx;
                c.weightx = 0.0;
                this.topFlagBoundariesPanel.add((Component)this.topFlagBoundarySpinner, c);
                this.bottomFlagBoundariesPanel.add((Component)this.bottomFlagBoundarySpinner, c);
                c.gridx = 0;
                c.gridy = 0;
                this.middleFlagBoundariesPanel.add((Component)this.middleFlagLowerBoundaryLabel, c);
                c.gridx = 1;
                this.middleFlagBoundariesPanel.add((Component)this.middleBoundaryLabel, c);
                c.gridx = 2;
                this.middleFlagBoundariesPanel.add((Component)this.middleFlagUpperBoundaryLabel, c);
            } else if (scaleId.equals(DISCRETE_SCALE)) {
                this.setFlagModificationEnabled(true);
                c.weightx = 1.0;
                this.topFlagBoundariesPanel.add((Component)this.topFlagValuesField, c);
                this.middleFlagBoundariesPanel.add((Component)this.middleFlagValuesField, c);
                this.bottomFlagBoundariesPanel.add((Component)this.bottomFlagValuesField, c);
            } else if (scaleId.equals(DISABLED_SCALE)) {
                this.setFlagModificationEnabled(false);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void setShowingDiscreteScaleExample(boolean showing) {
        if (showing) {
            this.showingDiscreteScaleExample = true;
            this.topFlagValuesField.setText("use ; as separator");
            this.middleFlagValuesField.setText("0;2;-1");
            this.bottomFlagValuesField.setText("");
        } else {
            this.showingDiscreteScaleExample = false;
            this.topFlagValuesField.setText("");
            this.middleFlagValuesField.setText("");
            this.bottomFlagValuesField.setText("");
            this.topFlagValuesField.setForeground(Color.black);
            this.middleFlagValuesField.setForeground(Color.black);
            this.bottomFlagValuesField.setForeground(Color.black);
        }
    }

    private DecimalFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("0.00##");
            DecimalFormatSymbols symbols = this.decimalFormat.getDecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.decimalFormat.setDecimalFormatSymbols(symbols);
        }
        return this.decimalFormat;
    }

    private void applyDefaultBoundaries() {
        this.topFlagBoundarySpinner.setValue(this.topFlagDefaultBoundary);
        this.bottomFlagBoundarySpinner.setValue(this.bottomFlagDefaultBoundary);
        this.boundariesAreValid = true;
        if (this.topFlagDefaultBoundary >= this.bottomFlagDefaultBoundary) {
            this.setUpperBoundary(this.topFlagDefaultBoundary);
            this.setLowerBoundary(this.bottomFlagDefaultBoundary);
            this.upperBoundarySpinner = this.topFlagBoundarySpinner;
            this.lowerBoundarySpinner = this.bottomFlagBoundarySpinner;
            this.topFlagOrderSelector.setSelectedItem(UPPER_BOUNDARY_LABEL);
        } else {
            this.setUpperBoundary(this.bottomFlagDefaultBoundary);
            this.setLowerBoundary(this.topFlagDefaultBoundary);
            this.upperBoundarySpinner = this.bottomFlagBoundarySpinner;
            this.lowerBoundarySpinner = this.topFlagBoundarySpinner;
            this.topFlagOrderSelector.setSelectedItem(LOWER_BOUNDARY_LABEL);
        }
    }

    private void setOrder(String topFlagBoundaryLabel) {
        double upperBoundary = (Double)this.upperBoundarySpinner.getValue();
        double lowerBoundary = (Double)this.lowerBoundarySpinner.getValue();
        if (topFlagBoundaryLabel.equals(UPPER_BOUNDARY_LABEL)) {
            this.upperBoundarySpinner = this.topFlagBoundarySpinner;
            this.lowerBoundarySpinner = this.bottomFlagBoundarySpinner;
            this.bottomFlagOrderLabel.setText(LOWER_BOUNDARY_LABEL);
        } else if (topFlagBoundaryLabel.equals(LOWER_BOUNDARY_LABEL)) {
            this.upperBoundarySpinner = this.bottomFlagBoundarySpinner;
            this.lowerBoundarySpinner = this.topFlagBoundarySpinner;
            this.bottomFlagOrderLabel.setText(UPPER_BOUNDARY_LABEL);
        }
        if (this.boundariesAreValid) {
            this.upperBoundarySpinner.setValue(upperBoundary);
            this.lowerBoundarySpinner.setValue(lowerBoundary);
        } else {
            this.checkAndShowBoundaryValidity();
        }
        this.updateMiddleFlagBoundaries();
    }

    private void updateMiddleFlagBoundaries() {
        if (this.lowerBoundarySpinner != null && this.upperBoundarySpinner != null) {
            String lowerBoundaryText = this.getDecimalFormat().format(this.lowerBoundary);
            String upperBoundaryText = this.getDecimalFormat().format(this.upperBoundary);
            if (this.boundariesAreValid && !lowerBoundaryText.equals(upperBoundaryText)) {
                this.middleFlagLowerBoundaryLabel.setText(lowerBoundaryText);
                this.middleBoundaryLabel.setText(MIDDLE_BOUNDARY_LABEL);
                this.middleFlagUpperBoundaryLabel.setText(upperBoundaryText);
            } else {
                this.middleFlagLowerBoundaryLabel.setText(" ");
                this.middleBoundaryLabel.setText(" ");
                this.middleFlagUpperBoundaryLabel.setText(" ");
            }
        }
    }

    private void checkAndShowBoundaryValidity() {
        if (this.upperBoundary < this.lowerBoundary) {
            if (this.boundariesAreValid) {
                ((JSpinner.DefaultEditor)this.upperBoundarySpinner.getEditor()).getTextField().setForeground(Color.RED);
                ((JSpinner.DefaultEditor)this.lowerBoundarySpinner.getEditor()).getTextField().setForeground(Color.RED);
                this.boundariesAreValid = false;
            }
        } else if (!this.boundariesAreValid) {
            ((JSpinner.DefaultEditor)this.upperBoundarySpinner.getEditor()).getTextField().setForeground(Color.BLACK);
            ((JSpinner.DefaultEditor)this.lowerBoundarySpinner.getEditor()).getTextField().setForeground(Color.BLACK);
            this.boundariesAreValid = true;
        }
    }

    private void handleContentChangeFor(JFormattedTextField field) {
        String text = field.getText();
        try {
            double value = Double.parseDouble(text);
            field.setForeground(Color.black);
            int textLength = text.length();
            int extraTokens = 0;
            if (textLength <= 6 || (extraTokens = textLength - 6) > 10) {
                // empty if block
            }
            this.extraTokensForBoundaryFields.put(field, extraTokens);
            for (int archivedTokenCount : this.extraTokensForBoundaryFields.values()) {
                if (archivedTokenCount <= extraTokens) continue;
                extraTokens = archivedTokenCount;
            }
            if (this.spinnersForBoundaryFields.get(field) == this.lowerBoundarySpinner) {
                this.setLowerBoundary(value);
            } else {
                this.setUpperBoundary(value);
            }
            this.updateMiddleFlagBoundaries();
            this.checkAndShowBoundaryValidity();
            this.revalidate();
        }
        catch (NumberFormatException nfe) {
            field.setForeground(Color.red);
        }
    }

    private void setUpperBoundary(double value) {
        this.upperBoundary = value;
        this.updateFlagTrimmer();
        this.screen.getTableFrame().getTable().repaint();
    }

    private void setLowerBoundary(double value) {
        this.lowerBoundary = value;
        this.updateFlagTrimmer();
        this.screen.getTableFrame().getTable().repaint();
    }

    public String getTopFlag() {
        return this.topFlagDefault;
    }

    public String getMiddleFlag() {
        return this.middleFlagDefault;
    }

    public String getBottomFlag() {
        return this.bottomFlagDefault;
    }

    public double getTopFlagBoundary() {
        return (Double)this.topFlagBoundarySpinner.getValue();
    }

    public double getBottomFlagBoundary() {
        return (Double)this.bottomFlagBoundarySpinner.getValue();
    }

    public boolean topFlagHasBiggestValues() {
        return ((String)this.topFlagOrderSelector.getSelectedItem()).equals(UPPER_BOUNDARY_LABEL);
    }

    public void setTopFlagBoundary(double value) {
        if (this.topFlagHasBiggestValues()) {
            this.setUpperBoundary(value);
            this.upperBoundarySpinner.setValue(value);
        } else {
            this.setLowerBoundary(value);
            this.lowerBoundarySpinner.setValue(value);
        }
    }

    public void setBottomFlagBoundary(double value) {
        if (this.topFlagHasBiggestValues()) {
            this.setLowerBoundary(value);
            this.lowerBoundarySpinner.setValue(value);
        } else {
            this.setUpperBoundary(value);
            this.upperBoundarySpinner.setValue(value);
        }
    }

    public boolean isFlagModificationEnabled() {
        return this.flagNameLabels[0].isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.scaleLabel.setEnabled(enabled);
        this.scaleSelector.setEnabled(enabled);
        if (enabled) {
            this.setScale(DISCRETE_SCALE);
        } else {
            this.setScale(DISABLED_SCALE);
        }
    }

    public void setFlagModificationEnabled(boolean enabled) {
        for (int i = 0; i < this.flagNameLabels.length; ++i) {
            this.flagNameLabels[i].setEnabled(enabled);
        }
        this.topFlagValuesField.setEnabled(enabled);
        this.middleFlagValuesField.setEnabled(enabled);
        this.bottomFlagValuesField.setEnabled(enabled);
        this.setBoundaryAdjustmentEnabled(enabled);
    }

    public void setBoundaryAdjustmentEnabled(boolean enabled) {
        this.topFlagOrderSelector.setEnabled(enabled);
        this.topFlagBoundarySpinner.setEnabled(enabled);
        this.middleFlagLowerBoundaryLabel.setEnabled(enabled);
        this.middleBoundaryLabel.setEnabled(enabled);
        this.middleFlagUpperBoundaryLabel.setEnabled(enabled);
        this.bottomFlagOrderLabel.setEnabled(enabled);
        this.bottomFlagBoundarySpinner.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.topFlagOrderSelector) {
            this.setOrder((String)this.topFlagOrderSelector.getSelectedItem());
        } else if (source == this.scaleSelector) {
            this.showScale((String)this.scaleSelector.getSelectedItem());
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        Object source = e.getSource();
        if (source instanceof JFormattedTextField) {
            JFormattedTextField field = (JFormattedTextField)source;
            this.handleContentChangeFor(field);
        } else if (source instanceof JTextField) {
            if ((source == this.topFlagValuesField || source == this.middleFlagValuesField || source == this.bottomFlagValuesField) && this.showingDiscreteScaleExample) {
                this.setShowingDiscreteScaleExample(false);
            }
            this.updateFlagTrimmer();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof JSpinner) {
            if (source == this.upperBoundarySpinner) {
                this.setUpperBoundary((Double)this.upperBoundarySpinner.getValue());
            } else if (source == this.lowerBoundarySpinner) {
                this.setLowerBoundary((Double)this.lowerBoundarySpinner.getValue());
            }
            if (this.upperBoundarySpinner != null && this.lowerBoundarySpinner != null) {
                this.checkAndShowBoundaryValidity();
            }
            this.updateMiddleFlagBoundaries();
            this.screen.getTableFrame().getTable().repaint();
        }
    }

    public void updateFlagTrimmer() {
        ColumnTypeManager manager = this.screen.getColumnTypeManager();
        ArrayList<DataTrimmingOperation> operations = new ArrayList<DataTrimmingOperation>();
        for (DataColumn column : manager.getColumns()) {
            int columnIndex;
            if (column.getColumnType() != ColumnType.FLAG_LABEL) continue;
            if (this.scale.equals(CONTINUOUS_SCALE)) {
                columnIndex = column.getColumnIndex();
                if (this.topFlagHasBiggestValues()) {
                    operations.add(new ConditionalStringReplace(Double.NEGATIVE_INFINITY, this.lowerBoundary, false, false, this.getBottomFlag(), columnIndex));
                    operations.add(new ConditionalStringReplace(this.lowerBoundary, this.upperBoundary, true, false, this.getMiddleFlag(), columnIndex));
                    operations.add(new ConditionalStringReplace(this.upperBoundary, Double.POSITIVE_INFINITY, true, false, this.getTopFlag(), columnIndex));
                    continue;
                }
                operations.add(new ConditionalStringReplace(Double.NEGATIVE_INFINITY, this.lowerBoundary, false, false, this.getTopFlag(), columnIndex));
                operations.add(new ConditionalStringReplace(this.lowerBoundary, this.upperBoundary, true, false, this.getMiddleFlag(), columnIndex));
                operations.add(new ConditionalStringReplace(this.upperBoundary, Double.POSITIVE_INFINITY, true, false, this.getBottomFlag(), columnIndex));
                continue;
            }
            if (!this.scale.equals(DISCRETE_SCALE)) continue;
            columnIndex = column.getColumnIndex();
            if (this.topFlagValuesField.getText() != null && this.topFlagValuesField.getText().length() > 0) {
                operations.addAll(FlagValuePanel.parseDiscreteString(this.topFlagValuesField.getText(), this.getTopFlag(), columnIndex));
            }
            if (this.middleFlagValuesField.getText() != null && this.middleFlagValuesField.getText().length() > 0) {
                operations.addAll(FlagValuePanel.parseDiscreteString(this.middleFlagValuesField.getText(), this.getMiddleFlag(), columnIndex));
            }
            if (this.bottomFlagValuesField.getText() == null || this.bottomFlagValuesField.getText().length() <= 0) continue;
            operations.addAll(FlagValuePanel.parseDiscreteString(this.bottomFlagValuesField.getText(), this.getBottomFlag(), columnIndex));
        }
        this.screen.getFlagTrimmer().clear();
        this.screen.getFlagTrimmer().pushOperations(operations);
        this.screen.getTableFrame().getTable().repaint();
    }

    public static void main(String[] args) {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.putAll(VisualConstants.getUIDefaults());
        FlagValuePanel panel = new FlagValuePanel(null);
        JFrame frame = new JFrame("FlagValuePanel Demo");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static List<DataTrimmingOperation> parseDiscreteString(String discrete, String replacement, int columnIndex) {
        String[] splitted;
        ArrayList<DataTrimmingOperation> operations = new ArrayList<DataTrimmingOperation>();
        for (String oldString : splitted = discrete.split(";")) {
            DataTrimmingOperation operation;
            try {
                Double stringAsNumber = Double.parseDouble(oldString);
                operation = new NumberToStringReplace(stringAsNumber, replacement, columnIndex);
            }
            catch (NumberFormatException nfe) {
                operation = new NormalStringReplace(oldString, replacement, true, columnIndex);
            }
            operations.add(operation);
        }
        return operations;
    }

    static {
        LOWER_BOUNDARY_LABEL = "x <";
        UPPER_BOUNDARY_LABEL = "x \u2265";
        MIDDLE_BOUNDARY_LABEL = "\u2264 x <";
        ORDER_SELECTOR_WIDTH = 50;
        DISABLED_SCALE = "Disabled";
        CONTINUOUS_SCALE = "Continuous";
        DISCRETE_SCALE = "Discrete";
    }
}

