/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class ActionChooserScreen
extends ScreenBase
implements ActionListener,
ChipsterDialog.DialogCloseListener {
    private static final String FRAME_TEXT = "Choose how to proceed with each file. A file can be imported directly as it is or you can use the Import tool to define the contents of the file. You can also decide not to import a file at all.";
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int TYPE_COLUMN_INDEX = 1;
    private static final int ACTION_COLUMN_INDEX = 2;
    private JFrame frame = new JFrame("Import files");
    private JCheckBox sameSettingsCheckBox;
    private JButton okButton;
    private JButton cancelButton;
    private JXTable table;
    private DefaultTableModel tableModel;
    private ImportSession importSession;

    public ActionChooserScreen(ImportSession importSession) {
        SwingClientApplication.setPlastic3DLookAndFeel(this.frame);
        this.frame.setPreferredSize(new Dimension(640, 480));
        this.frame.setLocationByPlatform(true);
        this.importSession = importSession;
        this.table = this.getTable();
        JScrollPane scroll = new JScrollPane(this.table);
        JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 20));
        JLabel infoLabel = new JLabel("<html><p>Choose how to proceed with each file. A file can be imported directly as it is or you can use the Import tool to define the contents of the file. You can also decide not to import a file at all.</p></html>", 2);
        infoLabel.setVerticalTextPosition(1);
        infoLabel.setPreferredSize(new Dimension(630, 40));
        upperPanel.add(infoLabel);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("  OK  ");
        this.cancelButton = new JButton("Cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JLabel sameSettingsLabel = new JLabel("<html><p>When using Import tool to import more than one files, only define the contents of the first file and then apply the same settings for the rest of the files.</p></html>", 2);
        sameSettingsLabel.setVerticalTextPosition(1);
        sameSettingsLabel.setPreferredSize(new Dimension(550, 40));
        this.sameSettingsCheckBox = new JCheckBox("Define file structure once and apply the same settings to all files");
        this.sameSettingsCheckBox.setEnabled(true);
        this.sameSettingsCheckBox.setSelected(true);
        this.sameSettingsCheckBox.setPreferredSize(new Dimension(550, 40));
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 18;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.insets = new Insets(5, 5, 10, 5);
        buttonPanel.add((Component)this.sameSettingsCheckBox, g);
        g.insets = new Insets(5, 0, 10, 5);
        ++g.gridy;
        g.anchor = 13;
        buttonPanel.add((Component)this.cancelButton, g);
        ++g.gridx;
        buttonPanel.add((Component)this.okButton, g);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)upperPanel, "North");
        this.frame.add((Component)scroll, "Center");
        this.frame.add((Component)buttonPanel, "South");
        this.frame.pack();
        this.frame.pack();
    }

    private JXTable getTable() {
        if (this.table == null) {
            class ActionChooserTableModel
            extends DefaultTableModel {
                public final String[] COLUMNS = new String[]{"Filename", "Detected type", "Action"};

                public ActionChooserTableModel(ImportSession importSession) {
                    Object[][] data = new Object[importSession.getItemCount()][];
                    for (int row = 0; row < data.length; ++row) {
                        ImportItem item = importSession.getItemAtIndex(row);
                        Object[] rowData = new Object[]{item.getOutput().getName(), item.getType(), item.getAction()};
                        data[row] = rowData;
                    }
                    this.setDataVector(data, this.COLUMNS);
                }

                public boolean isCellEditable(int row, int column) {
                    return column == 0 || column == 2;
                }

                public int getRowCount() {
                    return ActionChooserScreen.this.importSession.getItemCount();
                }

                public Object getValueAt(int row, int column) {
                    if (row >= this.getRowCount() || row < 0) {
                        throw new ArrayIndexOutOfBoundsException(row);
                    }
                    ImportItem item = ActionChooserScreen.this.importSession.getItemAtIndex(row);
                    if (column == 0) {
                        return item.getOutput().getName();
                    }
                    if (column == 1) {
                        return item.getType().getDescription();
                    }
                    if (column == 2) {
                        return item.getAction();
                    }
                    throw new ArrayIndexOutOfBoundsException(row);
                }

                public void setValueAt(Object value, int row, int column) {
                    ImportItem item = ActionChooserScreen.this.importSession.getItemAtIndex(row);
                    if (column == 2) {
                        item.setAction((ImportItem.Action)((Object)value));
                    } else if (column == 0) {
                        item.setFilename((String)value);
                    } else {
                        throw new IllegalArgumentException("Illegal column: " + column);
                    }
                    this.fireTableCellUpdated(row, column);
                }
            }
            this.tableModel = new ActionChooserTableModel(this.importSession);
            this.table = new JXTable(this.tableModel);
            this.table.getColumnModel().getColumn(1).setCellRenderer(new GreyTableCellRenderer());
            this.table.getColumnModel().getColumn(2).setCellRenderer(new ComboBoxRenderer(ImportItem.Action.values()));
            this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JComboBox<ImportItem.Action>(ImportItem.Action.values())));
            return this.table;
        }
        return this.table;
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String warnings = "";
            for (int row = 0; row < this.importSession.getItemCount(); ++row) {
                int index = this.table.convertRowIndexToModel(row);
                ImportItem item = this.importSession.getItemAtIndex(index);
                File file = item.getInput();
                if (!item.getType().isBinary() || !item.getAction().equals((Object)ImportItem.Action.CUSTOM)) continue;
                warnings = warnings + "File " + file.getName() + " is possibly a binary file, which cannot be handled by import tool.\n";
            }
            if (warnings.length() > 0) {
                DialogInfo info = new DialogInfo(DialogInfo.Severity.WARNING, "Possibly attempting import of binary file", "Import tool can describe only files that contain text formatted tables. For example ZIP archived files cannot be used. See details for more information. Select Ok to proceed or Cancel to go back.", warnings, true);
                ChipsterDialog.showDialog(null, info, ChipsterDialog.DetailsVisibility.DETAILS_VISIBLE, false, this);
                return;
            }
            this.doImports();
        } else if (e.getSource() == this.cancelButton) {
            this.frame.dispose();
        }
    }

    public void dialogClosed(boolean okSelected) {
        if (okSelected) {
            this.doImports();
        }
    }

    private void doImports() {
        for (int row = 0; row < this.importSession.getItemCount(); ++row) {
            this.table.setRowSelectionInterval(row, row);
            int index = this.table.convertRowIndexToModel(row);
            ImportItem item = this.importSession.getItemAtIndex(index);
            if (!item.getAction().equals((Object)ImportItem.Action.DIRECT)) continue;
            Session.getSession().getApplication().importData(ImportUtils.convertToDatasetName(item.getOutput().getName()), item.getType(), this.importSession.getDestinationFolder(), item.getInput());
        }
        if (this.importSession.hasCustomFiles()) {
            this.importSession.setUseSameDescriptions(this.sameSettingsCheckBox.isSelected());
            ((SwingClientApplication)Session.getSession().getApplication()).openImportTool(this.importSession);
        }
        this.frame.dispose();
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        ActionChooserScreen screen = new ActionChooserScreen(new ImportSession(ImportSession.Source.FILES, new ArrayList<File>(), "my experiment", false));
        screen.getFrame().setVisible(true);
    }

    public class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxRenderer(ImportItem.Action[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    private class GreyTableCellRenderer
    extends DefaultTableCellRenderer {
        private GreyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(false);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

