/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphRenderer;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.ParentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupVertex
extends AbstractGraphVertex {
    private ClientApplication application = Session.getSession().getApplication();
    public static boolean DEFAULT_COLLAPSED_STATE_WHEN_CREATED = true;
    public static Color DEFAULT_VERTEX_COLOR = VisualConstants.CATEGORY_COLORS[0];
    public static final Border BORDER_NORMAL = BorderFactory.createLineBorder(Color.black);
    private static final int DEFAULT_WIDTH = 60;
    private static final int DEFAULT_HEIGHT = 25;
    public static final Stroke COLLAPSED_SELECTION_STROKE = new BasicStroke(2.0f);
    public static final Color COLLAPSED_SELECTED_BORDER_COLOR = Color.BLACK;
    public static final Stroke EXPANDED_SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    public static final Color EXPANDED_SELECTED_BORDER_COLOR = new Color(127, 127, 127);
    private boolean isCollapsed;

    public GroupVertex(int x, int y, GraphVertex[] children, MicroarrayGraph graph) {
        super(x, y, null, graph);
        this.addPort();
        GraphConstants.setInset(this.getAttributes(), 10);
        GraphConstants.setGradientColor(this.getAttributes(), DEFAULT_VERTEX_COLOR);
        GraphConstants.setBorderColor(this.getAttributes(), Color.black);
        GraphConstants.setOpaque(this.getAttributes(), true);
        graph.getGraphLayoutCache().toBack(new Object[]{this});
        for (GraphVertex vertex : children) {
            this.addChildVertex(vertex);
        }
        graph.repaint();
    }

    private void setCollapsedState(boolean isCollapsed) {
        this.isCollapsed = isCollapsed;
        GraphConstants.setSelectable(this.getAttributes(), isCollapsed);
        if (isCollapsed) {
            this.getGraph().getGraphLayoutCache().toFront(new Object[]{this});
        } else {
            this.getGraph().getGraphLayoutCache().toBack(new Object[]{this});
        }
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public List<AbstractGraphVertex> getChildVertexes() {
        ArrayList<AbstractGraphVertex> vertexes = new ArrayList<AbstractGraphVertex>();
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof AbstractGraphVertex)) continue;
            vertexes.add((AbstractGraphVertex)child);
        }
        return vertexes;
    }

    public List<DataBean> getChildrenData() {
        ArrayList<DataBean> childData = new ArrayList<DataBean>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof GraphVertex)) continue;
            GraphVertex vertex = (GraphVertex)child;
            assert (vertex.getData() instanceof DataBean);
            childData.add(vertex.getData());
        }
        return childData;
    }

    public boolean isInCollapseHandleHitRegion(Point2D point, JGraph graph) {
        GraphRenderer groupRenderer;
        CellView view = graph.getGraphLayoutCache().getMapping(this, false);
        point.setLocation(point.getX() - (double)this.getX(), point.getY() - (double)this.getY());
        Component renderer = view.getRendererComponent(graph, false, false, false);
        return renderer instanceof GraphRenderer && (groupRenderer = (GraphRenderer)renderer).inHitRegion(point);
    }

    @Override
    public String toString() {
        int childCount = this.getChildCount() - 1;
        if (childCount > 1) {
            return childCount + " files";
        }
        return childCount + " file";
    }

    @Override
    public int getDefaultHeight() {
        return 25;
    }

    @Override
    public int getDefaultWidth() {
        return 60;
    }

    @Override
    public String getToolTipString() {
        return this.toString();
    }

    public boolean isSelectable() {
        Boolean selectable = (Boolean)this.getAttributes().get("selectable");
        return selectable;
    }

    @Override
    public void addChildVertex(GraphVertex vertex) {
        boolean wasCollapsed = this.isCollapsed();
        if (this.isCollapsed()) {
            this.expand();
        }
        ParentMap pm = new ParentMap(new Object[]{vertex}, this);
        this.getGraph().getGraphLayoutCache().edit(null, null, pm, null);
        if (wasCollapsed) {
            this.collapse();
        }
    }

    public void collapse() {
        this.getGraph().getGraphLayoutCache().collapse(new Object[]{this});
        this.setCollapsedState(true);
        this.getGraph().updateSelectedCells();
    }

    public void expand() {
        this.getGraph().getGraphLayoutCache().expand(new Object[]{this});
        this.setCollapsedState(false);
        this.getGraph().updateSelectedCells();
    }

    public boolean isAllChildrenSelected() {
        List<DataBean> selectedDatas = this.application.getSelectionManager().getSelectedDataBeans();
        if (selectedDatas.size() == 0) {
            return false;
        }
        for (DataBean childData : this.getChildrenData()) {
            if (selectedDatas.contains(childData)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeChildVertex(GraphVertex vertex) {
        if (!this.contains(vertex)) {
            return false;
        }
        boolean wasCollapsed = this.isCollapsed();
        if (this.isCollapsed()) {
            this.expand();
        }
        ParentMap pm = new ParentMap(new Object[]{vertex}, null);
        this.getGraph().getGraphLayoutCache().edit(null, null, pm, null);
        if (wasCollapsed) {
            this.collapse();
        }
        if (this.getChildVertexes().size() == 0) {
            this.getGraph().getGraphLayoutCache().remove(new Object[]{this});
        }
        return true;
    }

    public boolean contains(GraphVertex vertex) {
        return vertex.getGroup().equals(this);
    }
}

