/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.auth.LoginModuleBase;
import fi.csc.microarray.util.config.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileLoginModule
extends LoginModuleBase {
    private static final Logger logger = Logger.getLogger(SimpleFileLoginModule.class);
    private static final String DEFAULT_PASSWD_FILE = "/users.default";
    protected File passwdFile;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String passwdFileName = (String)options.get("passwdFile");
        if (passwdFileName == null || passwdFileName.equals("")) {
            this.createDefaultPasswdFile();
            return;
        }
        this.passwdFile = new File(passwdFileName);
        if (this.passwdFile.isAbsolute()) {
            if (!this.passwdFile.exists()) {
                logger.warn("Passwd file " + this.passwdFile.getPath() + " not found.");
            }
        } else {
            this.passwdFile = new File(MicroarrayConfiguration.getWorkDir(), this.passwdFile.getName());
            if (!this.passwdFile.exists()) {
                logger.warn("Passwd file " + this.passwdFile.getPath() + " not found.");
                this.createDefaultPasswdFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean authenticate(String username, char[] password) throws IOException {
        block23: {
            block22: {
                block20: {
                    block21: {
                        SimpleFileLoginModule.logger.debug(this.getClass().getName() + " authenticating " + username);
                        reader = new BufferedReader(new FileReader(this.passwdFile));
                        lineBegin = new char[username.length() + password.length + 1];
                        try {
                            readCount = SimpleFileLoginModule.readToken(lineBegin, reader);
lbl6:
                            // 2 sources

                            while (readCount != -1) {
                                skipToNextLine = false;
                                if (readCount < lineBegin.length) ** GOTO lbl62
                                if (lineBegin[0] == '#') {
                                    skipToNextLine = true;
                                }
                                if (!skipToNextLine) {
                                    for (i = 0; i < username.length(); ++i) {
                                        if (username.charAt(i) == lineBegin[i]) continue;
                                        skipToNextLine = true;
                                    }
                                }
                                if (!skipToNextLine && lineBegin[username.length()] != ':') {
                                    skipToNextLine = true;
                                }
                                if (!skipToNextLine) {
                                    for (i = 0; i < password.length; ++i) {
                                        if (password[i] == lineBegin[username.length() + 1 + i]) continue;
                                        skipToNextLine = true;
                                    }
                                }
                                if (skipToNextLine) ** GOTO lbl-1000
                                next = reader.read();
                                if (next == -1) {
                                    var8_8 = true;
                                    if (lineBegin == null) break block20;
                                    i = 0;
                                    break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl64
                        }
                        catch (Throwable var11_12) {
                            if (lineBegin != null) {
                                for (i = 0; i < lineBegin.length; ++i) {
                                    lineBegin[i] = 32;
                                }
                                lineBegin = null;
                            }
                            throw var11_12;
                        }
                    }
                    while (true) {
                        if (i >= lineBegin.length) {
                            return var8_8;
                        }
                        lineBegin[i] = 32;
                        ++i;
                    }
                }
                return var8_8;
lbl-1000:
                // 1 sources

                {
                    c = (char)next;
                    if (c != ':' && !SimpleFileLoginModule.isNewLineChar(c) && !Character.isWhitespace(c)) ** GOTO lbl-1000
                    var9_10 = true;
                    if (lineBegin == null) break block22;
                    i = 0;
                }
                while (true) {
                    if (i >= lineBegin.length) {
                        return var9_10;
                    }
                    lineBegin[i] = 32;
                    ++i;
                }
            }
            return var9_10;
lbl-1000:
            // 2 sources

            {
                SimpleFileLoginModule.skipToLineEnd(reader);
lbl62:
                // 2 sources

                readCount = SimpleFileLoginModule.readToken(lineBegin, reader);
                ** GOTO lbl6
lbl64:
                // 1 sources

                var5_5 = false;
                if (lineBegin == null) break block23;
                i = 0;
            }
            while (true) {
                if (i >= lineBegin.length) {
                    return var5_5;
                }
                lineBegin[i] = 32;
                ++i;
            }
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultPasswdFile() {
        try {
            File defaultFile = new File(MicroarrayConfiguration.getWorkDir(), "users");
            if (defaultFile.exists()) {
                return;
            }
            logger.info("Creating new default passwd file " + defaultFile.getPath());
            InputStream defaults = Configuration.class.getResourceAsStream(DEFAULT_PASSWD_FILE);
            FileOutputStream out = new FileOutputStream(defaultFile);
            try {
                IO.copy(defaults, out);
            }
            finally {
                if (defaults != null) {
                    defaults.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Could not create default users file.", ioe);
        }
    }
}

