/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.RetryException;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AnalysisJob
implements Runnable {
    private static final Logger logger = Logger.getLogger(AnalysisJob.class);
    protected JobMessage inputMessage;
    protected ResultCallback resultHandler;
    protected AnalysisDescription analysis;
    private Date receiveTime;
    private Date scheduleTime;
    private Date executionStartTime;
    private Date executionEndTime;
    private boolean constructed = false;
    private JobState state = JobState.NEW;
    private String stateDetail = "New job created.";
    private boolean toBeCanceled = false;
    protected ResultMessage outputMessage;

    public void construct(JobMessage inputMessage, AnalysisDescription analysis, ResultCallback resultHandler) {
        this.constructed = true;
        this.analysis = analysis;
        this.inputMessage = inputMessage;
        this.resultHandler = resultHandler;
        this.outputMessage = new ResultMessage();
        this.outputMessage.setJobId(this.getId());
        this.outputMessage.setReplyTo(inputMessage.getReplyTo());
        this.outputMessage.setState(this.state);
        this.outputMessage.setStateDetail(this.stateDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (!this.constructed) {
                throw new IllegalStateException("you must call construct(...) first");
            }
            this.preExecute();
            this.setExecutionStartTime(new Date());
            this.execute();
            this.setExecutionEndTime(new Date());
            this.postExecute();
            if (!this.getState().equals((Object)JobState.RUNNING)) {
                throw new RuntimeException("Unexpected job end state: " + (Object)((Object)this.getState()));
            }
            this.updateState(JobState.COMPLETED, "", false);
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        catch (JobCancelledException jce) {
            this.setExecutionEndTime(new Date());
            logger.debug("Job cancelled: " + this.getId());
        }
        catch (RetryException re) {
            this.setExecutionEndTime(new Date());
            logger.info("Sending retry request for " + this.getId());
            this.updateState(JobState.RETRY, "", false);
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail("Waiting for resend.");
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        catch (Throwable e) {
            this.setExecutionEndTime(new Date());
            String msg = this.analysis.getFullName() + " failed: ";
            if (this.getState() == JobState.FAILED) {
                msg = msg + " R finished with error";
                logger.info(msg);
                this.outputMessage.setErrorMessage(msg);
            } else if (this.getState() == JobState.FAILED_USER_ERROR) {
                msg = msg + " R finished with error";
                logger.info(msg);
                this.outputMessage.setErrorMessage(msg);
            } else if (this.getState() == JobState.TIMEOUT) {
                msg = msg + "R running over timeout";
                logger.info(msg);
                this.outputMessage.setErrorMessage(msg);
            } else {
                msg = msg + "unexpected error";
                logger.error(msg, e);
                this.updateState(JobState.ERROR, "Unexpected server error", false);
                this.outputMessage.setErrorMessage(e.toString());
            }
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
        finally {
            try {
                this.cleanUp();
            }
            catch (Throwable t) {
                logger.error("Error when cleaning up.", t);
            }
            this.resultHandler.removeRunningJob(this);
        }
    }

    public String getId() {
        return this.inputMessage.getJobId();
    }

    public synchronized void updateState(JobState newState, String newStateDetail, boolean sendNotification) {
        if (this.getState() == JobState.CANCELLED) {
            return;
        }
        this.state = newState;
        this.stateDetail = newStateDetail;
        if (sendNotification) {
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
    }

    public synchronized void updateStateDetail(String newStateDetail, boolean sendNotification) {
        if (this.state.equals((Object)JobState.CANCELLED)) {
            return;
        }
        this.stateDetail = newStateDetail;
        if (sendNotification) {
            this.outputMessage.setState(this.state);
            this.outputMessage.setStateDetail(this.stateDetail);
            this.resultHandler.sendResultMessage(this.inputMessage, this.outputMessage);
        }
    }

    public JobState getState() {
        return this.state;
    }

    public void cancel() {
        logger.debug("Canceling job " + this.getId());
        this.toBeCanceled = true;
        this.cancelRequested();
    }

    protected void cancelCheck() throws JobCancelledException {
        if (this.toBeCanceled) {
            this.updateState(JobState.CANCELLED, "", false);
            throw new JobCancelledException();
        }
    }

    protected abstract void cancelRequested();

    protected abstract void execute() throws Exception;

    protected void preExecute() throws Exception {
        if (!this.constructed) {
            throw new IllegalStateException("you must call construct(...) first");
        }
        this.updateState(JobState.RUNNING, "Initialising", true);
    }

    protected void postExecute() throws Exception {
    }

    protected void cleanUp() {
    }

    public JobMessage getInputMessage() {
        return this.inputMessage;
    }

    public Date getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }
}

