/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.TimeoutMap;
import org.apache.camel.util.TimeoutMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTimeoutMap
implements TimeoutMap,
Runnable {
    private static final Log LOG = LogFactory.getLog(DefaultTimeoutMap.class);
    private Map map = new HashMap();
    private SortedSet index = new TreeSet();
    private ScheduledExecutorService executor;
    private long purgePollTime;

    public DefaultTimeoutMap() {
        this(null, 1000L);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        this.executor = executor;
        this.purgePollTime = requestMapPollTimeMillis;
        this.schedulePoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        TimeoutMapEntry entry = null;
        Map map = this.map;
        synchronized (map) {
            entry = (TimeoutMapEntry)this.map.get(key);
            if (entry == null) {
                return null;
            }
            this.index.remove(entry);
            this.updateExpireTime(entry);
            this.index.add(entry);
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value, long timeoutMillis) {
        TimeoutMapEntry entry = new TimeoutMapEntry(key, value, timeoutMillis);
        Map map = this.map;
        synchronized (map) {
            TimeoutMapEntry oldValue = this.map.put(key, entry);
            if (oldValue != null) {
                this.index.remove(oldValue);
            }
            this.updateExpireTime(entry);
            this.index.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object id) {
        Map map = this.map;
        synchronized (map) {
            TimeoutMapEntry entry = (TimeoutMapEntry)this.map.remove(id);
            if (entry != null) {
                this.index.remove(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKeys() {
        Object[] keys = null;
        Map map = this.map;
        synchronized (map) {
            Set keySet = this.map.keySet();
            keys = new String[keySet.size()];
            keySet.toArray(keys);
        }
        return keys;
    }

    public void run() {
        this.purge();
        this.schedulePoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        long now = this.currentTime();
        Map map = this.map;
        synchronized (map) {
            TimeoutMapEntry entry;
            Iterator iter = this.index.iterator();
            while (iter.hasNext() && (entry = (TimeoutMapEntry)iter.next()) != null && entry.getExpireTime() < now) {
                if (!this.isValidForEviction(entry)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Evicting inactive request for correlationID: " + entry));
                }
                this.map.remove(entry.getKey());
                iter.remove();
            }
        }
    }

    public long getPurgePollTime() {
        return this.purgePollTime;
    }

    public void setPurgePollTime(long purgePollTime) {
        this.purgePollTime = purgePollTime;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    protected void schedulePoll() {
        if (this.executor != null) {
            this.executor.schedule(this, this.purgePollTime, TimeUnit.MILLISECONDS);
        }
    }

    protected boolean isValidForEviction(TimeoutMapEntry entry) {
        return true;
    }

    protected void updateExpireTime(TimeoutMapEntry entry) {
        long now = this.currentTime();
        entry.setExpireTime(entry.getTimeout() + now);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }
}

