/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.commons.logging.Log;

public class ThroughputLogger
extends Logger {
    private int groupSize = 100;
    private long startTime;
    private AtomicInteger receivedCounter = new AtomicInteger();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();

    public ThroughputLogger() {
    }

    public ThroughputLogger(Log log) {
        super(log);
    }

    public ThroughputLogger(Log log, LoggingLevel level) {
        super(log, level);
    }

    public ThroughputLogger(String logName) {
        super(logName);
    }

    public ThroughputLogger(String logName, LoggingLevel level) {
        super(logName, level);
    }

    public ThroughputLogger(String logName, LoggingLevel level, int groupSize) {
        super(logName, level);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(String logName, int groupSize) {
        super(logName);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(int groupSize) {
        this.setGroupSize(groupSize);
    }

    public void process(Exchange exchange) {
        int receivedCount;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if ((receivedCount = this.receivedCounter.incrementAndGet()) % this.groupSize == 0) {
            super.process(exchange);
        }
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int groupSize) {
        if (groupSize == 0) {
            throw new IllegalArgumentException("groupSize cannot be zero!");
        }
        this.groupSize = groupSize;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    protected Object logMessage(Exchange exchange) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        this.startTime = time;
        double rate = (double)this.groupSize * 1000.0;
        return "Received: " + this.receivedCounter.get() + " messages so far. Last group took: " + elapsed + " millis which is: " + this.numberFormat.format(rate /= (double)elapsed) + " messages per second";
    }
}

