/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.CamelInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyHelper {
    private ProxyHelper() {
    }

    public static Object createProxy(Endpoint endpoint, ClassLoader cl, Class[] interfaces) throws Exception {
        Producer producer = endpoint.createProducer();
        return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)new CamelInvocationHandler(endpoint, producer));
    }

    public static Object createProxy(Endpoint endpoint, Class[] interfaces) throws Exception {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("You must provide at least 1 interface class.");
        }
        return ProxyHelper.createProxy(endpoint, interfaces[0].getClassLoader(), interfaces);
    }

    public static <T> T createProxy(Endpoint endpoint, ClassLoader cl, Class<T> interfaceClass) throws Exception {
        return (T)ProxyHelper.createProxy(endpoint, cl, new Class[]{interfaceClass});
    }

    public static <T> T createProxy(Endpoint endpoint, Class<T> interfaceClass) throws Exception {
        return (T)ProxyHelper.createProxy(endpoint, new Class[]{interfaceClass});
    }
}

