/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.fest.assertions.Assert;
import org.fest.assertions.Fail;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageAssert
extends Assert<BufferedImage> {
    public static BufferedImage read(String imageFilePath) {
        File imageFile = new File(imageFilePath);
        if (!imageFile.isFile()) {
            Fail.fail(Strings.concat((Object[])new Object[]{"The path ", Strings.quote((String)imageFilePath), "does not belong to a file"}));
        }
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            Fail.fail(Strings.concat((Object[])new Object[]{"Unable to read image from file ", Strings.quote((String)imageFilePath)}), e);
            return null;
        }
    }

    public ImageAssert(BufferedImage actual) {
        super(actual);
    }

    public final ImageAssert isEqualTo(BufferedImage expected) {
        if (!ImageAssert.areEqual((BufferedImage)this.actual, expected)) {
            Fail.fail("Images are not equal");
        }
        return this;
    }

    public final ImageAssert isNotEqualTo(BufferedImage image) {
        if (ImageAssert.areEqual((BufferedImage)this.actual, image)) {
            Fail.fail("Images not equal");
        }
        return this;
    }

    private static boolean areEqual(BufferedImage first, BufferedImage second) {
        if (first == null) {
            return second == null;
        }
        int width = first.getWidth();
        int height = first.getHeight();
        if (width != second.getWidth()) {
            return false;
        }
        if (height != second.getHeight()) {
            return false;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (first.getRGB(x, y) == second.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public final ImageAssert isNotNull() {
        return (ImageAssert)super.isNotNull();
    }

    public final ImageAssert isNotSameAs(BufferedImage expected) {
        return (ImageAssert)super.isNotSameAs(expected);
    }

    public final ImageAssert isSameAs(BufferedImage expected) {
        return (ImageAssert)super.isSameAs(expected);
    }

    public final void hasSize(Dimension expected) {
        Dimension actual = new Dimension(((BufferedImage)this.actual).getWidth(), ((BufferedImage)this.actual).getHeight());
        Fail.failIfNotEqual(actual, expected);
    }
}

