/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleArrayAssert
extends GroupAssert<double[]> {
    DoubleArrayAssert(double ... actual) {
        super(actual);
    }

    public DoubleArrayAssert isNotNull() {
        return (DoubleArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((double[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((double[])this.actual), ">"}));
        }
    }

    public DoubleArrayAssert isNotEmpty() {
        if (((double[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public DoubleArrayAssert isEqualTo(double[] expected) {
        if (!Arrays.equals((double[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((double[])this.actual)));
        }
        return this;
    }

    public DoubleArrayAssert isNotEqualTo(double[] array) {
        if (Arrays.equals((double[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((double[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((double[])this.actual).length;
    }

    public DoubleArrayAssert hasSize(int expected) {
        return (DoubleArrayAssert)super.hasSize(expected);
    }

    public DoubleArrayAssert isSameAs(double[] expected) {
        return (DoubleArrayAssert)super.isSameAs(expected);
    }

    public DoubleArrayAssert isNotSameAs(double[] expected) {
        return (DoubleArrayAssert)super.isNotSameAs(expected);
    }
}

