/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;
import org.fest.assertions.PrimitiveFail;
import org.fest.util.Strings;

public class CharAssert {
    private final char actual;

    CharAssert(char actual) {
        this.actual = actual;
    }

    public CharAssert isEqualTo(char expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public CharAssert isNotEqualTo(char other) {
        PrimitiveFail.failIfEqual(this.actual, other);
        return this;
    }

    public CharAssert isGreaterThan(char smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public CharAssert isLessThan(char bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public CharAssert isUpperCase() {
        if (!Character.isUpperCase(this.actual)) {
            Fail.fail(Strings.concat((Object[])new Object[]{String.valueOf(this.actual), " should be an uppercase character"}));
        }
        return this;
    }

    public CharAssert isLowerCase() {
        if (!Character.isLowerCase(this.actual)) {
            Fail.fail(Strings.concat((Object[])new Object[]{String.valueOf(this.actual), " should be a lowercase character"}));
        }
        return this;
    }
}

