/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteArrayAssert
extends GroupAssert<byte[]> {
    ByteArrayAssert(byte ... actual) {
        super(actual);
    }

    public ByteArrayAssert isNotNull() {
        return (ByteArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((byte[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((byte[])this.actual), ">"}));
        }
    }

    public ByteArrayAssert isNotEmpty() {
        if (((byte[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public ByteArrayAssert isEqualTo(byte[] expected) {
        if (!Arrays.equals((byte[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((byte[])this.actual)));
        }
        return this;
    }

    public ByteArrayAssert isNotEqualTo(byte[] array) {
        if (Arrays.equals((byte[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((byte[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((byte[])this.actual).length;
    }

    public ByteArrayAssert hasSize(int expected) {
        return (ByteArrayAssert)super.hasSize(expected);
    }

    public ByteArrayAssert isSameAs(byte[] expected) {
        return (ByteArrayAssert)super.isSameAs(expected);
    }

    public ByteArrayAssert isNotSameAs(byte[] expected) {
        return (ByteArrayAssert)super.isNotSameAs(expected);
    }
}

