/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanArrayAssert
extends GroupAssert<boolean[]> {
    BooleanArrayAssert(boolean ... actual) {
        super(actual);
    }

    public BooleanArrayAssert isNotNull() {
        return (BooleanArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((boolean[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((boolean[])this.actual), ">"}));
        }
    }

    public BooleanArrayAssert isNotEmpty() {
        if (((boolean[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public BooleanArrayAssert isEqualTo(boolean[] expected) {
        if (!Arrays.equals((boolean[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((boolean[])this.actual)));
        }
        return this;
    }

    public BooleanArrayAssert isNotEqualTo(boolean[] array) {
        if (Arrays.equals((boolean[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((boolean[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((boolean[])this.actual).length;
    }

    public BooleanArrayAssert hasSize(int expected) {
        return (BooleanArrayAssert)super.hasSize(expected);
    }

    public BooleanArrayAssert isSameAs(boolean[] expected) {
        return (BooleanArrayAssert)super.isSameAs(expected);
    }

    public BooleanArrayAssert isNotSameAs(boolean[] expected) {
        return (BooleanArrayAssert)super.isNotSameAs(expected);
    }
}

