/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Platform;
import abbot.util.ProcessOutputHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;

public class Launcher {
    private static final String[] HTTP = new String[]{"firefox", "galeon", "konqueror", "opera", "mozilla", "netscape", "mosaic"};

    private static String encodeForMail(String base) {
        StringBuffer buf = new StringBuffer(base);
        String SPACE = "--SPACE--";
        int idx = buf.toString().indexOf(" ");
        while (idx != -1) {
            buf.replace(idx, idx + 1, SPACE);
            idx = buf.toString().indexOf(" ");
        }
        buf = new StringBuffer(URLEncoder.encode(buf.toString()));
        idx = buf.toString().indexOf(SPACE);
        while (idx != -1) {
            if (Platform.isOSX()) {
                buf.replace(idx, idx + SPACE.length(), "%20");
            } else {
                buf.replace(idx, idx + SPACE.length(), " ");
            }
            idx = buf.toString().indexOf(SPACE);
        }
        return buf.toString();
    }

    public static void mail(String user, String subject, String body) throws IOException {
        Launcher.mail(user, subject, body, null);
    }

    public static void mail(String user, String subject, String body, String cc) throws IOException {
        Launcher.mail(user, subject, body, cc, null);
    }

    public static void mail(String user, String subject, String body, String cc, String bcc) throws IOException {
        StringBuffer mailto = new StringBuffer("mailto:" + user + "?");
        if (cc != null) {
            mailto.append("CC=" + cc + "&");
        }
        if (bcc != null) {
            mailto.append("BCC=" + bcc + "&");
        }
        mailto.append("Subject=" + Launcher.encodeForMail(subject) + "&" + "Body=" + Launcher.encodeForMail(body) + "");
        Launcher.open(mailto.toString());
    }

    public static void open(String target) throws IOException {
        Launcher.open(null, target);
    }

    public static void open(String command, String target) throws IOException {
        boolean tryBrowsers = false;
        ArrayList<String> args = new ArrayList<String>();
        if (command != null) {
            args.add(command);
        } else if (Platform.isOSX()) {
            args.add("open");
        } else if (Platform.isWindows()) {
            if (Platform.isWindows9X()) {
                args.add("command.com");
                args.add("/o");
            } else {
                args.add("cmd.exe");
                args.add("/c");
                args.add("start");
                args.add("\"Title\"");
            }
            target = "\"" + target + "\"";
        } else {
            args.add("placeholder");
            tryBrowsers = true;
        }
        args.add(target);
        String[] cmd = args.toArray(new String[args.size()]);
        if (tryBrowsers) {
            for (int i = 0; i < HTTP.length; ++i) {
                try {
                    cmd[0] = HTTP[i];
                    ProcessOutputHandler.exec(cmd);
                    return;
                }
                catch (IOException e) {
                    continue;
                }
            }
            throw new IOException("No target handler found (tried " + Arrays.asList(HTTP) + ")");
        }
        ProcessOutputHandler.exec(cmd);
    }
}

