/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.Platform;
import abbot.i18n.Strings;
import abbot.tester.Robot;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Bugs {
    private static ArrayList bugList = null;
    private static boolean gotBug1Event = false;

    private Bugs() {
    }

    public static boolean hasMenuDisableBug() {
        return Platform.isOSX() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION < 5156;
    }

    public static boolean hasInputMethodInsteadOfKeyTyped() {
        return Platform.isOSX() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION < 5156;
    }

    public static boolean hasMissingWindowMouseMotion() {
        return Platform.isOSX() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION <= 5632;
    }

    public static boolean hasRobotButtonsSwapped() {
        return Platform.isOSX() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION <= 5157;
    }

    public static boolean hasMultiClickFrameBug() {
        return Platform.isWindows() || Platform.isOSX() || Platform.JAVA_VERSION < 4864;
    }

    public static boolean needsRobotVerification() {
        return Platform.isWindows();
    }

    public static boolean hasHierarchyEventGenerationBug() {
        return Platform.JAVA_VERSION < 5120;
    }

    public static boolean hasKeyStrokeGenerationBug() {
        return Platform.isOSX() && Platform.JAVA_VERSION < 5120;
    }

    public static boolean hasKeyInputDelay() {
        return Platform.isOSX() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION <= 5157;
    }

    public static boolean hasFrameDeiconifyBug() {
        return Platform.isOSX() && Platform.JAVA_VERSION > 4880 && Platform.JAVA_VERSION < 5156;
    }

    public static boolean hasRobotMotionBug() {
        return Platform.isOSX() || !Platform.isWindows() && Platform.JAVA_VERSION < 5120 || Boolean.getBoolean("abbot.robot.need_jitter");
    }

    public static boolean hasChoiceLockupBug() {
        return Platform.isOSX() && Platform.JAVA_VERSION < 5120;
    }

    public static boolean hasEscapeGenerationBug() {
        return Platform.isOSX() && Platform.JAVA_VERSION < 5120;
    }

    public static boolean showAWTPopupMenuBlocks() {
        return Platform.isWindows() && Platform.JAVA_VERSION <= 5632;
    }

    public static boolean reportsIncorrectLockingKeyState() {
        return Platform.isLinux() && Platform.JAVA_VERSION <= 5156;
    }

    public static boolean dragDropRequiresNativeEvents() {
        return Platform.JAVA_VERSION <= 5157;
    }

    public static boolean fileDialogRequiresDismiss() {
        return Platform.isOSX() && Platform.JAVA_VERSION <= 5632 || Platform.isWindows() && Platform.JAVA_VERSION < 5138;
    }

    public static boolean fileDialogMisreportsBounds() {
        return Platform.isOSX() && Platform.JAVA_VERSION <= 5632 || Platform.isWindows() && Platform.JAVA_VERSION <= 5376;
    }

    public static boolean fileDialogRequiresVisibleFrame() {
        return Platform.isWindows() && Platform.JAVA_VERSION <= 5153;
    }

    public static boolean hasTextComponentSelectionDelay() {
        return (Platform.isLinux() || Platform.isWindows()) && Platform.JAVA_VERSION <= 5156;
    }

    public static boolean hasNoAWTInputOnTextFieldBug() {
        return Platform.isLinux() && Platform.JAVA_VERSION < 5376 || Platform.isOSX() && Platform.JAVA_VERSION <= 5632;
    }

    public static boolean locksUpOnScreenCapture() {
        return Platform.isLinux() && Platform.JAVA_VERSION >= 5120 && Platform.JAVA_VERSION <= 5381;
    }

    public static String[] bugCheck(Window window) {
        if (bugList == null) {
            bugList = new ArrayList();
            final int x = window.getWidth() / 2;
            final int y = window.getHeight() / 2;
            if (Platform.isWindows() && !Platform.isWindowsXP() && Platform.JAVA_VERSION < 5120) {
                Log.debug("Checking for w32 bugs");
                int mask = 8;
                MouseAdapter ma = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        gotBug1Event = true;
                        if (e.getX() != x || e.getY() != y) {
                            bugList.add(Strings.get("Bug1"));
                        }
                        if ((e.getModifiers() & 8) != 8) {
                            bugList.add(Strings.get("Bug2"));
                        }
                    }
                };
                window.addMouseListener(ma);
                Robot robot = new Robot();
                robot.click(window, x, y, 8);
                robot.waitForIdle();
                window.toFront();
                if (!gotBug1Event) {
                    bugList.add(0, Strings.get("Bug1"));
                }
                window.removeMouseListener(ma);
            } else if (Platform.isOSX() && Platform.JAVA_VERSION < 5168) {
                Log.debug("Checking for OSX bugs");
                int mask = 8;
                MouseAdapter ma = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if ((e.getModifiers() & 8) != 8) {
                            bugList.add(Strings.get("robot.bug3"));
                        }
                    }
                };
                window.addMouseListener(ma);
                Robot robot = new Robot();
                robot.click(window, x, y, 8);
                robot.waitForIdle();
                window.removeMouseListener(ma);
            }
        }
        return bugList.toArray(new String[bugList.size()]);
    }
}

