/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JSlider;

public class JSliderTester
extends JComponentTester {
    private ComponentLocation valueToLocation(JSlider s, int value) {
        int range = s.getMaximum() - s.getMinimum();
        int x = s.getWidth() / 2;
        int y = s.getHeight() / 2;
        Insets insets = s.getInsets();
        float percent = (float)(value - s.getMinimum()) / (float)range;
        if (s.getOrientation() == 1) {
            int max = s.getHeight() - insets.top - insets.bottom - 1;
            y = (int)(percent * (float)max);
            if (!s.getInverted()) {
                y = max - y;
            }
        } else {
            int max = s.getWidth() - insets.left - insets.right - 1;
            x = (int)(percent * (float)max);
            if (s.getInverted()) {
                x = max - x;
            }
        }
        return new ComponentLocation(new Point(x, y));
    }

    public void actionIncrement(Component c) {
        JSlider s = (JSlider)c;
        this.actionClick(c, this.valueToLocation(s, s.getMaximum()));
    }

    public void actionDecrement(Component c) {
        JSlider s = (JSlider)c;
        this.actionClick(c, this.valueToLocation(s, s.getMinimum()));
    }

    public void actionSlide(Component c, final int value) {
        final JSlider s = (JSlider)c;
        if (JSliderTester.getEventMode() == EM_ROBOT) {
            this.actionDrag(c, this.valueToLocation(s, s.getValue()));
            this.actionDrop(c, this.valueToLocation(s, value));
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                s.setValue(value);
            }
        });
    }

    public void actionSlideMaximum(Component c) {
        this.actionSlide(c, ((JSlider)c).getMaximum());
    }

    public void actionSlideMinimum(Component c) {
        this.actionSlide(c, ((JSlider)c).getMinimum());
    }
}

