/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.widgets;

import abbot.Log;
import abbot.tester.Robot;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextArea
extends JTextArea {
    public static final String ACTION_FOCUS_LOST = "focus-lost";
    public static final String ACTION_TEXT_CHANGED = "text-changed";
    public static final String ACTION_TEXT_INSERTED = "text-changed";
    public static final String ACTION_TEXT_REMOVED = "text-changed";
    private boolean continuousFire = true;
    private boolean fieldChanging = false;
    private ArrayList listeners = new ArrayList();

    public TextArea(String value) {
        super(value);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent ev) {
                if (!ev.isTemporary() && !TextArea.this.isLocalMenuActive()) {
                    Log.debug("Firing on focus loss");
                    TextArea.this.fireActionPerformed(TextArea.ACTION_FOCUS_LOST);
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                if (!TextArea.this.fieldChanging && TextArea.this.continuousFire) {
                    TextArea.this.fireActionPerformed("text-changed");
                }
            }

            public void insertUpdate(DocumentEvent ev) {
                if (!TextArea.this.fieldChanging && TextArea.this.continuousFire) {
                    TextArea.this.fireActionPerformed("text-changed");
                }
            }

            public void removeUpdate(DocumentEvent ev) {
                if (!TextArea.this.fieldChanging && TextArea.this.continuousFire) {
                    TextArea.this.fireActionPerformed("text-changed");
                }
            }
        });
    }

    public void setText(String text) {
        this.fieldChanging = true;
        super.setText(text);
        this.fieldChanging = false;
    }

    private boolean isLocalMenuActive() {
        boolean active = false;
        Window window = SwingUtilities.getWindowAncestor(this);
        while (window != null && !active) {
            if (!((window = SwingUtilities.getWindowAncestor(window)) instanceof JFrame)) continue;
            Component comp = window.getFocusOwner();
            Log.debug("Focus is in " + Robot.toString(comp));
            active = comp != null && comp instanceof JMenuItem;
        }
        return active;
    }

    protected void fireActionPerformed(String actionCommand) {
        this.fireActionPerformed(actionCommand, false);
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this.getText(), true);
    }

    protected void fireActionPerformed(String cmd, boolean select) {
        if (select) {
            this.selectAll();
        }
        ActionEvent e = new ActionEvent(this, 1001, cmd);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }
}

