/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.ComponentRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;

public class ChoiceRecorder
extends ComponentRecorder {
    private Choice choice = null;
    private String selection = null;
    private ItemListener listener = null;
    static /* synthetic */ Class class$java$awt$Choice;

    public ChoiceRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int recordingType) {
        super.init(recordingType);
        this.choice = null;
        this.selection = null;
        this.listener = null;
    }

    protected boolean isClick(AWTEvent e) {
        if (e instanceof ItemEvent) {
            return true;
        }
        return super.isClick(e);
    }

    protected boolean parseClick(AWTEvent event) {
        if (this.isFinished()) {
            Log.debug("already finished");
            return false;
        }
        if (this.choice == null) {
            if (event instanceof ItemEvent) {
                this.choice = (Choice)event.getSource();
                this.selection = ((ItemEvent)event).getItem().toString();
                Log.debug("selection=" + this.selection);
                this.setFinished(true);
            } else {
                this.choice = (Choice)event.getSource();
                this.listener = new ItemListener(){

                    public void itemStateChanged(ItemEvent ev) {
                        Log.debug("item event");
                        if (ev.getStateChange() == 1) {
                            ChoiceRecorder.this.selection = ev.getItem().toString();
                            Log.debug("selection=" + ChoiceRecorder.this.selection);
                            ChoiceRecorder.this.choice.removeItemListener(this);
                            ChoiceRecorder.this.setFinished(true);
                        }
                    }
                };
                this.choice.addItemListener(this.listener);
                this.setStatus("Waiting for selection");
            }
        } else if (event.getID() == 402 && (((KeyEvent)event).getKeyCode() == 32 || ((KeyEvent)event).getKeyCode() == 10)) {
            Log.debug("enter");
            this.setFinished(true);
        } else if (event.getID() == 402 && ((KeyEvent)event).getKeyCode() == 27) {
            Log.debug("cancel");
            this.selection = null;
            this.setFinished(true);
        } else {
            Log.debug("Event ignored");
        }
        if (this.isFinished() && this.choice != null) {
            this.choice.removeItemListener(this.listener);
            this.listener = null;
        }
        return true;
    }

    protected Step createStep() {
        Step step = null;
        if (this.getRecordingType() == 3) {
            if (this.selection != null) {
                step = this.createSelection(this.choice, this.selection);
            }
        } else {
            step = super.createStep();
        }
        return step;
    }

    protected Step createSelection(Choice target, String selection) {
        ComponentReference cr = this.getResolver().addComponent(this.choice);
        return new Action(this.getResolver(), null, "actionSelectItem", new String[]{cr.getID(), selection}, class$java$awt$Choice == null ? (class$java$awt$Choice = ChoiceRecorder.class$("java.awt.Choice")) : class$java$awt$Choice);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

