/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.Log;
import abbot.editor.editors.SequenceEditor;
import abbot.editor.widgets.Mnemonic;
import abbot.i18n.Strings;
import abbot.script.Fixture;
import abbot.script.Script;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class ScriptEditor
extends SequenceEditor {
    private Script script;
    private JTextField path;
    private JCheckBox fork;
    private JTextField vmargs;

    public ScriptEditor(Script script) {
        super(script);
        this.script = script;
        this.path = this.addTextField(Strings.get("FilePath"), script.getFilename());
        if (!(script instanceof Fixture)) {
            this.fork = this.addCheckBox("", script.isForked());
            String key = "actions.toggle-forked";
            Mnemonic mnemonic = Mnemonic.getMnemonic(Strings.get(key));
            mnemonic.setMnemonic(this.fork);
            this.addVMArgs();
        }
    }

    private void addVMArgs() {
        if (this.script.isForked()) {
            this.vmargs = this.addTextField(Strings.get("VMArgs"), this.script.getVMArgs());
        } else if (this.vmargs != null) {
            while (this.getComponent(this.getComponentCount() - 1) != this.fork) {
                this.remove(this.getComponentCount() - 1);
            }
            this.vmargs = null;
        }
        this.revalidate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.path) {
            String filename = this.path.getText().trim();
            File file = new File(this.script.getRelativeTo(), filename);
            this.script.setFile(file);
            try {
                this.script.load();
            }
            catch (Exception exc) {
                Log.warn(exc);
            }
            this.fireStepChanged();
        } else if (src == this.fork) {
            this.script.setForked(!this.script.isForked());
            this.addVMArgs();
            this.fireStepChanged();
        } else if (src == this.vmargs) {
            String text = this.vmargs.getText();
            if ("".equals(text)) {
                text = null;
            }
            this.script.setVMArgs(text);
            this.fireStepChanged();
        } else {
            super.actionPerformed(ev);
        }
    }
}

