/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.wizard;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardPanelDescriptor;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.util.ThreadUtils;
import fi.csc.microarray.wizard.WizardContext;
import fi.csc.microarray.wizard.WizardParameterBundle;
import fi.csc.microarray.wizard.affymetrix.AffyWizardJob;
import fi.csc.microarray.wizard.affymetrix.FileGroup;
import fi.csc.microarray.wizard.affymetrix.FileGroupPanelDesc;
import fi.csc.microarray.wizard.affymetrix.GroupTestPanelDesc;
import fi.csc.microarray.wizard.affymetrix.NormalisationPanelDesc;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class WizardPlugin {
    private SwingClientApplication application;
    private WizardContext context;
    private Wizard wizard = null;
    private LinkedHashMap<String, WizardPanelDescriptor> panels;
    private AffyWizardJob job;

    public WizardPlugin(SwingClientApplication application) {
        this.application = application;
        this.context = application;
        this.wizard = new Wizard(application.getMainFrame());
        SwingClientApplication.setPlastic3DLookAndFeel(this.wizard.getDialog());
        this.job = new AffyWizardJob();
        this.panels = this.job.getPanels();
        for (WizardPanelDescriptor panel : this.panels.values()) {
            this.wizard.registerWizardPanel(panel.getPanelDescriptorIdentifier(), panel);
        }
        this.wizard.setCurrentPanel(this.panels.values().iterator().next().getPanelDescriptorIdentifier());
    }

    public void show() {
        int ret = this.wizard.showModalDialog();
        if (ret == 0) {
            final LinkedHashMap fileGroups = new LinkedHashMap();
            FileGroupPanelDesc groupDesc = (FileGroupPanelDesc)this.panels.get("FILE_GROUPING_PANEL");
            Vector groups = groupDesc.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                FileGroup group = (FileGroup)groups.elementAt(i);
                LinkedList<String> groupList = new LinkedList<String>();
                fileGroups.put(group.getName(), groupList);
                ArrayList<File> valueList = group.getFiles();
                ListIterator<File> iter = valueList.listIterator();
                while (iter.hasNext()) {
                    File file = iter.next();
                    groupList.add(file.getPath());
                }
            }
            try {
                Thread thread = ThreadUtils.getBackgroundThread(new Runnable(){

                    public void run() {
                        try {
                            GroupTestPanelDesc testDesc = (GroupTestPanelDesc)WizardPlugin.this.panels.get("GROUPTEST_PANEL");
                            NormalisationPanelDesc normalisationDesc = (NormalisationPanelDesc)WizardPlugin.this.panels.get("NORMALISATION_PANEL");
                            WizardParameterBundle parameters = new WizardParameterBundle();
                            parameters.add("fileGroups", fileGroups);
                            parameters.add("test", testDesc.getSelected());
                            parameters.add("normalizationMethod", normalisationDesc.getSelected());
                            WizardPlugin.this.job.execute(WizardPlugin.this.context, parameters);
                        }
                        catch (Exception e) {
                            WizardPlugin.this.application.reportException(e);
                        }
                    }
                });
                thread.start();
            }
            catch (Exception e) {
                this.application.reportException(e);
            }
            JOptionPane.showMessageDialog(this.application.getMainFrame(), "The wizard is running tasks. Please wait until it is finished.");
        }
    }
}

