/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private DocumentBuilder docBuilder;
    private static XmlUtil instance;

    public static synchronized XmlUtil getInstance() throws ParserConfigurationException {
        if (instance == null) {
            instance = new XmlUtil();
        }
        return instance;
    }

    private XmlUtil() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
    }

    public Document newDocument() throws ParserConfigurationException {
        return this.docBuilder.newDocument();
    }

    public Document parseFile(File file) throws SAXException, IOException {
        return this.docBuilder.parse(file);
    }

    public Document parseReader(Reader reader) throws SAXException, IOException {
        return this.docBuilder.parse(new InputSource(reader));
    }

    public void printXml(Document xml, Writer out) throws TransformerException, UnsupportedEncodingException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(xml), new StreamResult(out));
    }
}

