/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class FSDataManagerTest {
    @BeforeSuite
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
    }

    @Test
    public void testFSDataMangerInitialisation() throws IOException {
        new FSDataManager();
    }

    @Test
    public void testSnapshot() throws IOException, MicroarrayException {
        int dataCount;
        FSDataManager manager1 = new FSDataManager();
        String beanName1 = "My bean.txt";
        String beanName2 = "My other bean.txt";
        String beanName3 = "My other bean.txt";
        DataBean bean1 = manager1.createDataBean(beanName1);
        DataBean bean2 = manager1.createDataBean(beanName2);
        DataBean bean3 = manager1.createDataBean(beanName3);
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        manager1.getRootFolder().addChild(bean1);
        manager1.getRootFolder().addChild(bean2);
        manager1.getRootFolder().addChild(bean3);
        File snap = new File("temp-snapshot");
        if (snap.exists()) {
            Files.delTree(snap);
        }
        Assert.assertTrue(((dataCount = manager1.saveSnapshot(snap)) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)snap.exists());
        FSDataManager manager2 = new FSDataManager();
        manager2.loadSnapshot(snap, manager2.getRootFolder());
        DataFolder root1 = manager1.getRootFolder();
        DataFolder root2 = manager2.getRootFolder();
        Assert.assertEquals((String)root2.toStringRecursively(0), (String)root1.toStringRecursively(0));
        DataBean newBean1 = null;
        for (DataItem item : root2.getChildren()) {
            if (!item.getName().equals(beanName1)) continue;
            newBean1 = (DataBean)item;
            break;
        }
        Assert.assertNotNull((Object)newBean1.getContentByteStream());
        Assert.assertEquals((int)newBean1.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)1);
    }

    @Test
    public void testDataBeanCreation() throws IOException, MicroarrayException {
        FSDataManager manager = new FSDataManager();
        FSDataBean bean = manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
        BufferedInputStream originalData = new BufferedInputStream(new FileInputStream("examples/affy_example.cel"));
        BufferedInputStream beanData = new BufferedInputStream(bean.getContentByteStream());
        Assert.assertTrue((boolean)Files.equalInputStreamContent(originalData, beanData));
        manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
        manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
    }
}

