/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.workflow;

import bsh.EvalError;
import bsh.Interpreter;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.workflow.WorkflowWriter;
import fi.csc.microarray.client.workflow.api.WfApplication;
import fi.csc.microarray.util.Exceptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowManager {
    public static final String WORKFLOW_VERSION = "BSH/2";
    public static final String SCRIPT_EXTENSION = "bsh";
    public static final File SCRIPT_DIRECTORY = new File(MicroarrayConfiguration.getWorkDir().getAbsolutePath() + File.separator + "chipster-scripts");
    private ClientApplication application;

    public static void checkVersionHeaderLine(String line) throws IllegalArgumentException {
        if (!line.contains("BSH/2 ")) {
            throw new IllegalArgumentException("Script version not supported. Supported version is BSH/2, but script begins with " + line);
        }
    }

    public WorkflowManager(ClientApplication application) {
        this.application = application;
    }

    public List<String> getWorkflows() {
        LinkedList<String> workflows = new LinkedList<String>();
        if (SCRIPT_DIRECTORY.exists()) {
            File[] scripts;
            for (File script : scripts = SCRIPT_DIRECTORY.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(WorkflowManager.SCRIPT_EXTENSION);
                }
            })) {
                workflows.add(script.getName().substring(0, script.getName().length() - (SCRIPT_EXTENSION.length() + 1)));
            }
        }
        return workflows;
    }

    public void runScript(final File file, final AtEndListener listener) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    String line = in.readLine();
                    WorkflowManager.checkVersionHeaderLine(line);
                    in.close();
                    Interpreter i = WorkflowManager.this.initialiseBshEnvironment();
                    i.source(file.getPath());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    WorkflowManager.this.application.showDialog("Running workflow failed", "Running workflow " + file.getName() + " failed. Usually this is because the workflow contained operations that do not work with the data currently in use. For more information please see details below.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, true);
                }
                finally {
                    if (listener != null) {
                        listener.atEnd();
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public Interpreter initialiseBshEnvironment() {
        Interpreter i = new Interpreter();
        try {
            i.set("app", (Object)new WfApplication(Session.getSession().getApplication()));
        }
        catch (EvalError ee) {
            throw new RuntimeException("BeanShell console failed to open: " + ee.getMessage());
        }
        return i;
    }

    public void saveSelectedWorkflow(File selectedFile) throws IOException {
        WorkflowWriter writer = new WorkflowWriter();
        StringBuffer script = writer.writeWorkflow(this.application.getSelectionManager().getSelectedDataBean());
        this.saveScript(selectedFile, script);
        if (!writer.writeWarnings().isEmpty()) {
            String details = "";
            for (String warning : writer.writeWarnings()) {
                details = details + warning + "\n";
            }
            this.application.showDialog("Workflow not fully saved", "Some parts of workflow structure are not supported by current workflow system and they were skipped. The rest of the workflow was successfully saved.", details, DialogInfo.Severity.INFO, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScript(File scriptFile, StringBuffer currentWorkflowScript) throws IOException {
        PrintWriter scriptOut = null;
        try {
            scriptOut = new PrintWriter(new OutputStreamWriter(new FileOutputStream(scriptFile)));
            scriptOut.print(currentWorkflowScript.toString());
        }
        finally {
            if (scriptOut != null) {
                scriptOut.close();
            }
        }
    }

    public void initialiseScriptDirectory() throws IOException {
        boolean ok;
        if (!SCRIPT_DIRECTORY.exists() && !(ok = SCRIPT_DIRECTORY.mkdir())) {
            throw new IOException(SCRIPT_DIRECTORY.getPath() + " could not be created");
        }
    }
}

